/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.bjurr.violations.lib.model.generated.sarif.ArtifactLocation;
import se.bjurr.violations.lib.model.generated.sarif.OriginalUriBaseIds;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializationContext;
import se.bjurr.violations.violationslib.com.google.gson.JsonDeserializer;
import se.bjurr.violations.violationslib.com.google.gson.JsonElement;
import se.bjurr.violations.violationslib.com.google.gson.JsonObject;
import se.bjurr.violations.violationslib.com.google.gson.JsonPrimitive;

public class SarifParserOriginalUri {
    private static Logger LOGGER = Logger.getLogger(SarifParserOriginalUri.class.getSimpleName());

    static Map<String, String> getOriginalUriBaseIdsMap(OriginalUriBaseIds originalUriBaseIds) {
        TreeMap<String, String> originalUriBaseIdsMap = new TreeMap<String, String>();
        if (originalUriBaseIds == null) {
            return originalUriBaseIdsMap;
        }
        Map<String, ArtifactLocation> additionalProperties = originalUriBaseIds.getAdditionalProperties();
        if (additionalProperties == null) {
            return originalUriBaseIdsMap;
        }
        for (String baseId : additionalProperties.keySet()) {
            originalUriBaseIdsMap.put(baseId, SarifParserOriginalUri.getOriginalUriBaseIdsMapValue(additionalProperties, baseId));
        }
        return originalUriBaseIdsMap;
    }

    private static String getOriginalUriBaseIdsMapValue(Map<String, ArtifactLocation> additionalProperties, String baseId) {
        for (Map.Entry<String, ArtifactLocation> candidate : additionalProperties.entrySet()) {
            if (!candidate.getKey().equals(baseId)) continue;
            String uriBaseId = candidate.getValue().getUriBaseId();
            if (uriBaseId != null) {
                String resolvedBase = SarifParserOriginalUri.getOriginalUriBaseIdsMapValue(additionalProperties, uriBaseId);
                return resolvedBase + candidate.getValue().getUri();
            }
            return candidate.getValue().getUri();
        }
        return "";
    }

    static class OriginalUriBaseIdsStringsDeserializer
    implements JsonDeserializer<OriginalUriBaseIds> {
        OriginalUriBaseIdsStringsDeserializer() {
        }

        @Override
        public OriginalUriBaseIds deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            try {
                OriginalUriBaseIds to = new OriginalUriBaseIds();
                for (Map.Entry<String, JsonElement> entry : json.getAsJsonObject().entrySet()) {
                    ArtifactLocation al = this.toArtifactLocation(entry.getValue());
                    to.setAdditionalProperty(entry.getKey(), al);
                }
                return to;
            }
            catch (RuntimeException e) {
                LOGGER.log(Level.SEVERE, json.toString(), e);
                return new OriginalUriBaseIds();
            }
        }

        private ArtifactLocation toArtifactLocation(JsonElement artifactLocationJsonElement) {
            ArtifactLocation al = new ArtifactLocation();
            if (artifactLocationJsonElement instanceof JsonObject) {
                JsonElement uriBaseIdAttr;
                JsonObject valueObject = artifactLocationJsonElement.getAsJsonObject();
                JsonElement uriAttr = valueObject.get("uri");
                if (uriAttr != null) {
                    al.setUri(uriAttr.getAsString());
                }
                if ((uriBaseIdAttr = valueObject.get("uriBaseId")) != null) {
                    al.setUriBaseId(uriBaseIdAttr.getAsString());
                }
            } else if (artifactLocationJsonElement instanceof JsonPrimitive) {
                al.setUri(artifactLocationJsonElement.getAsString());
            }
            if (al.getUri() == null) {
                al.setUri("");
            }
            return al;
        }
    }
}

