/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CloseHookFileListener<T extends FileAnalysisListener>
implements FileAnalysisListener {
    private final T delegate;

    public CloseHookFileListener(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onRuleViolation(RuleViolation violation) {
        this.delegate.onRuleViolation(violation);
    }

    @Override
    public void onSuppressedRuleViolation(Report.SuppressedViolation violation) {
        this.delegate.onSuppressedRuleViolation(violation);
    }

    @Override
    public void onError(Report.ProcessingError error) {
        this.delegate.onError(error);
    }

    @Override
    public final void close() throws Exception {
        Exception e = null;
        try {
            this.delegate.close();
        }
        catch (Exception ex) {
            e = ex;
        }
        this.doClose(this.delegate, e);
    }

    public String toString() {
        return "CloseHookFileListener [delegate=" + this.delegate + "]";
    }

    protected abstract void doClose(T var1, @Nullable Exception var2) throws Exception;
}

