/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import org.apache.commons.lang3.StringUtils;

public class TextColorRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "textcolor";
    private String pwd;
    private String yellowBold = "\u001b[1;33m";
    private String whiteBold = "\u001b[1;37m";
    private String redBold = "\u001b[1;31m";
    private String red = "\u001b[0;31m";
    private String green = "\u001b[0;32m";
    private String cyan = "\u001b[0;36m";
    private String colorReset = "\u001b[0m";

    public TextColorRenderer() {
        super(NAME, "Text format, with color support (requires ANSI console support, e.g. xterm, rxvt, etc.).");
    }

    @Override
    public String defaultFileExtension() {
        return "txt";
    }

    @Override
    public void outputReport(Report report) throws IOException {
        String nextFile;
        StringBuilder buf = new StringBuilder(500);
        buf.append(System.lineSeparator());
        String lastFile = null;
        int numberOfErrors = 0;
        int numberOfWarnings = 0;
        for (RuleViolation ruleViolation : report.getViolations()) {
            buf.setLength(0);
            ++numberOfWarnings;
            nextFile = this.determineFileName(ruleViolation.getFileId());
            if (!nextFile.equals(lastFile)) {
                lastFile = nextFile;
                buf.append(this.yellowBold).append("*").append(this.colorReset).append(" file: ").append(this.whiteBold).append(this.getRelativePath(lastFile)).append(this.colorReset).append(System.lineSeparator());
            }
            buf.append(this.green).append("    src:  ").append(this.cyan).append(lastFile.substring(lastFile.lastIndexOf(File.separator) + 1)).append(this.colorReset).append(":").append(this.cyan).append(ruleViolation.getBeginLine()).append(ruleViolation.getEndLine() == -1 ? "" : ":" + ruleViolation.getEndLine()).append(this.colorReset).append(System.lineSeparator());
            buf.append(this.green).append("    rule: ").append(this.colorReset).append(ruleViolation.getRule().getName()).append(System.lineSeparator());
            buf.append(this.green).append("    msg:  ").append(this.colorReset).append(ruleViolation.getDescription()).append(System.lineSeparator());
            buf.append(this.green).append("    code: ").append(this.colorReset).append(this.getLine(lastFile, ruleViolation.getBeginLine())).append(System.lineSeparator()).append(System.lineSeparator());
            this.writer.write(buf.toString());
        }
        this.writer.println();
        this.writer.println();
        this.writer.println("Summary:");
        this.writer.println();
        for (Map.Entry entry : TextColorRenderer.getCountSummary(report).entrySet()) {
            buf.setLength(0);
            String key = (String)entry.getKey();
            buf.append(key).append(" : ").append(entry.getValue());
            this.writer.println(buf);
        }
        for (Report.ProcessingError processingError : report.getProcessingErrors()) {
            buf.setLength(0);
            ++numberOfErrors;
            nextFile = this.determineFileName(processingError.getFileId());
            if (!nextFile.equals(lastFile)) {
                lastFile = nextFile;
                buf.append(this.redBold).append("*").append(this.colorReset).append(" file: ").append(this.whiteBold).append(this.getRelativePath(lastFile)).append(this.colorReset).append(System.lineSeparator());
            }
            buf.append(this.green).append("    err:  ").append(this.cyan).append(processingError.getMsg()).append(this.colorReset).append(System.lineSeparator()).append(this.red).append(processingError.getDetail()).append(this.colorReset).append(System.lineSeparator());
            this.writer.println(buf);
        }
        for (Report.ConfigurationError configurationError : report.getConfigurationErrors()) {
            buf.setLength(0);
            ++numberOfErrors;
            buf.append(this.redBold).append("*").append(this.colorReset).append(" rule: ").append(this.whiteBold).append(configurationError.rule().getName()).append(this.colorReset).append(System.lineSeparator());
            buf.append(this.green).append("    err:  ").append(this.cyan).append(configurationError.issue()).append(this.colorReset).append(System.lineSeparator());
            this.writer.println(buf);
        }
        if (numberOfErrors > 0) {
            this.writer.println(this.redBold + "*" + this.colorReset + " errors:   " + this.whiteBold + numberOfErrors + this.colorReset);
        }
        this.writer.println(this.yellowBold + "*" + this.colorReset + " warnings: " + this.whiteBold + numberOfWarnings + this.colorReset);
    }

    private static Map<String, Integer> getCountSummary(Report report) {
        HashMap<String, Integer> summary = new HashMap<String, Integer>();
        for (RuleViolation rv : report.getViolations()) {
            String key = TextColorRenderer.keyFor(rv);
            if (key.isEmpty()) continue;
            Integer o = (Integer)summary.get(key);
            summary.put(key, o == null ? 1 : o + 1);
        }
        return summary;
    }

    private static String keyFor(RuleViolation rv) {
        String packageName = rv.getAdditionalInfo().getOrDefault("packageName", "");
        String className = rv.getAdditionalInfo().getOrDefault("className", "");
        return StringUtils.isNotBlank((CharSequence)packageName) ? packageName + '.' + className : "";
    }

    private String getLine(String sourceFile, int line) {
        String code = null;
        try (BufferedReader br = new BufferedReader(this.getReader(sourceFile));){
            for (int i = 0; line > i; ++i) {
                String txt = br.readLine();
                code = txt == null ? "" : txt.trim();
            }
        }
        catch (IOException ioErr) {
            ioErr.printStackTrace();
        }
        return code;
    }

    protected Reader getReader(String sourceFile) throws FileNotFoundException {
        try {
            return Files.newBufferedReader(new File(sourceFile).toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            FileNotFoundException ex = new FileNotFoundException(sourceFile);
            ex.initCause(e);
            throw ex;
        }
    }

    private String getRelativePath(String fileName) {
        String relativePath;
        if (this.pwd == null) {
            try {
                this.pwd = new File(".").getCanonicalPath();
            }
            catch (IOException ioErr) {
                this.pwd = "";
            }
        }
        if (fileName.indexOf(this.pwd) == 0) {
            relativePath = "." + fileName.substring(this.pwd.length());
            if (relativePath.startsWith("." + File.separator + "." + File.separator)) {
                relativePath = relativePath.substring(2);
            }
        } else {
            relativePath = fileName;
        }
        return relativePath;
    }
}

