/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import net.sourceforge.pmd.properties.PropertyConstraint;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.xml.SchemaConstants;

public final class NumericConstraints {
    private NumericConstraints() {
    }

    public static <N extends Comparable<N>> PropertyConstraint<N> inRange(N minInclusive, N maxInclusive) {
        return PropertyConstraint.fromPredicate(t -> minInclusive.compareTo(t) <= 0 && maxInclusive.compareTo(t) >= 0, "Should be between " + minInclusive + " and " + maxInclusive, CollectionUtil.mapOf(SchemaConstants.PROPERTY_MIN.xmlName(), String.valueOf(minInclusive), SchemaConstants.PROPERTY_MAX.xmlName(), String.valueOf(maxInclusive)));
    }

    public static <N extends Comparable<N>> PropertyConstraint<N> above(N minInclusive) {
        return PropertyConstraint.fromPredicate(t -> minInclusive.compareTo(t) <= 0, "Should be greater or equal to " + minInclusive, CollectionUtil.mapOf(SchemaConstants.PROPERTY_MIN.xmlName(), String.valueOf(minInclusive)));
    }

    public static <N extends Comparable<N>> PropertyConstraint<N> below(N maxInclusive) {
        return PropertyConstraint.fromPredicate(t -> maxInclusive.compareTo(t) >= 0, "Should be smaller or equal to " + maxInclusive, CollectionUtil.mapOf(SchemaConstants.PROPERTY_MAX.xmlName(), String.valueOf(maxInclusive)));
    }

    public static <N extends Number> PropertyConstraint<N> positive() {
        return PropertyConstraint.fromPredicate(t -> t.intValue() > 0, "Should be positive");
    }
}

