/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.internal;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.rule.internal.TopoOrder;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.GraphUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class LatticeRelation<K, @NonNull V, C> {
    private final Predicate<? super K> queryKeySelector;
    private final TopoOrder<K> keyOrder;
    private final Function<? super K, String> keyToString;
    private final Collector<? super V, ?, ? extends C> collector;
    private final C emptyValue;
    private final Map<K, LNode> nodes = new HashMap<K, LNode>();

    <A> LatticeRelation(TopoOrder<K> keyOrder, Predicate<? super K> queryKeySelector, Function<? super K, String> keyToString, Collector<? super V, A, ? extends C> collector) {
        this.keyOrder = keyOrder;
        this.queryKeySelector = queryKeySelector;
        this.keyToString = keyToString;
        this.collector = collector;
        this.emptyValue = CollectionUtil.finish(collector, collector.supplier().get());
    }

    <A> LatticeRelation(TopoOrder<K> keyOrder, Set<? extends K> querySet, Function<? super K, String> keyToString, Collector<? super V, A, ? extends C> collector) {
        this.keyOrder = keyOrder;
        this.queryKeySelector = querySet::contains;
        this.keyToString = keyToString;
        this.collector = collector;
        this.emptyValue = CollectionUtil.finish(collector, collector.supplier().get());
        for (K k : querySet) {
            if (k == null) {
                throw new IllegalArgumentException("Query set " + querySet + " contains a null key");
            }
            this.putDontCheckParams(k, null);
        }
    }

    private void addSucc(@Nullable Deque<LNode> preds, K k, @Nullable V val) {
        if (CollectionUtil.any(preds, n -> n.key.equals(k))) {
            throw this.cycleError(preds, k);
        }
        LNode n2 = this.nodes.get(k);
        if (n2 != null) {
            this.link(preds, n2, val);
            return;
        }
        n2 = this.queryKeySelector.test(k) ? new QueryNode(k) : new LNode(k);
        this.nodes.put(k, n2);
        this.link(preds, n2, val);
        if (preds == null) {
            preds = new ArrayDeque<LNode>();
        }
        preds.addLast(n2);
        for (K next : this.keyOrder.directSuccessors(k)) {
            this.addSucc(preds, next, val);
        }
        if (preds.removeLast() != n2) {
            throw new IllegalStateException("Unbalanced stack push/pop");
        }
    }

    private void link(@Nullable Iterable<LNode> preds, LNode n, @Nullable V val) {
        if (preds != null) {
            n.addAsSuccessorTo(preds);
        }
        n.addValueTransitive(val);
    }

    private @NonNull IllegalStateException cycleError(@NonNull Deque<LNode> preds, K k) {
        List toStrings = CollectionUtil.map(CollectionUtil.toMutableList(), preds, n -> this.keyToString.apply(n.key));
        toStrings.add(this.keyToString.apply(k));
        return new IllegalStateException("Cycle in graph: " + String.join((CharSequence)" -> ", toStrings));
    }

    Set<K> transitiveQuerySuccs(K key) {
        LNode lNode = this.nodes.get(key);
        if (lNode == null) {
            return Collections.emptySet();
        }
        return CollectionUtil.map(Collectors.toSet(), lNode.transitiveSuccs, n -> n.key);
    }

    public void put(@NonNull K key, @NonNull V value) {
        AssertionUtil.requireParamNotNull("key", key);
        AssertionUtil.requireParamNotNull("value", value);
        this.putDontCheckParams(key, value);
    }

    private void putDontCheckParams(@NonNull K key, @Nullable V value) {
        this.addSucc(null, key, value);
    }

    public @NonNull C get(@NonNull K key) {
        AssertionUtil.requireParamNotNull("key", key);
        LNode n = this.nodes.get(key);
        return n == null ? this.emptyValue : n.computeValue();
    }

    public void clearValues() {
        for (LNode n : this.nodes.values()) {
            n.resetValue();
        }
    }

    public String toString() {
        return GraphUtil.toDot(this.nodes.values(), n -> n.transitiveSuccs, n -> n.getClass() == QueryNode.class ? GraphUtil.DotColor.GREEN : GraphUtil.DotColor.BLACK, n -> this.keyToString.apply(n.key));
    }

    private class LNode {
        protected final @NonNull K key;
        final Set<QueryNode<?>> transitiveSuccs = new LinkedHashSet();

        LNode(K key) {
            this.key = key;
        }

        void addValueTransitive(@Nullable V v) {
            if (v == null) {
                return;
            }
            this.addValue(v);
            this.transitiveSuccs.forEach(s -> s.addValue(v));
        }

        void addAsSuccessorTo(Iterable<LNode> preds) {
            for (QueryNode<?> it : this.transitiveSuccs) {
                it.addAsSuccessorTo(preds);
            }
        }

        void addValue(@NonNull V v) {
        }

        @NonNull C computeValue() {
            return LatticeRelation.this.emptyValue;
        }

        void resetValue() {
        }

        public String toString() {
            return "node(" + this.key + ')';
        }
    }

    private final class QueryNode<A>
    extends LNode {
        private A accumulator;
        private C finished;

        QueryNode(K key) {
            super(key);
            this.resetValue();
        }

        @Override
        void addAsSuccessorTo(Iterable<LNode> preds) {
            preds.forEach(n -> {
                if (n.transitiveSuccs.add(this)) {
                    n.transitiveSuccs.addAll(this.transitiveSuccs);
                }
            });
        }

        @Override
        void addValue(@NonNull V v) {
            this.collector().accumulator().accept(this.accumulator, v);
        }

        @Override
        @NonNull C computeValue() {
            if (this.finished == null) {
                this.finished = CollectionUtil.finish(this.collector(), this.accumulator);
            }
            return this.finished;
        }

        @Override
        void resetValue() {
            this.accumulator = this.collector().supplier().get();
            this.finished = null;
        }

        @Override
        public String toString() {
            return "qnode(" + this.key + ')';
        }

        private Collector<? super V, A, ? extends C> collector() {
            return LatticeRelation.this.collector;
        }
    }
}

