/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.internal.AncestorOrSelfIterator;
import net.sourceforge.pmd.lang.ast.internal.Filtermap;
import net.sourceforge.pmd.lang.ast.internal.IteratorBasedNStream;
import net.sourceforge.pmd.lang.ast.internal.StreamImpl;
import net.sourceforge.pmd.lang.ast.internal.TraversalUtils;
import net.sourceforge.pmd.lang.ast.internal.TreeWalker;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AxisStream<T extends Node>
extends IteratorBasedNStream<T> {
    protected final Node node;
    protected final Filtermap<Node, ? extends T> filter;

    AxisStream(@NonNull Node root, Filtermap<Node, ? extends T> filter) {
        this.node = root;
        this.filter = filter;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.filter.filterMap(this.baseIterator());
    }

    protected abstract Iterator<Node> baseIterator();

    @Override
    public <R extends Node> NodeStream<@NonNull R> map(Function<? super T, ? extends @Nullable R> mapper) {
        return this.copyWithFilter(this.filter.thenApply(mapper));
    }

    @Override
    public NodeStream<T> filter(Predicate<? super @NonNull T> predicate) {
        return this.copyWithFilter(this.filter.thenFilter(predicate));
    }

    @Override
    public <S extends Node> NodeStream<S> filterIs(Class<? extends S> r1Class) {
        return this.copyWithFilter(this.filter.thenCast(r1Class));
    }

    protected <O extends Node> @Nullable O firstImpl(Filtermap<? super Node, ? extends O> filter) {
        Iterator<O> iter = filter.filterMap(this.baseIterator());
        return (O)(iter.hasNext() ? (Node)iter.next() : null);
    }

    protected <O extends Node> @Nullable O lastImpl(Filtermap<? super Node, ? extends O> filter) {
        Iterator<? extends O> iter = filter.filterMap(this.baseIterator());
        return (O)((Node)IteratorUtil.last(iter));
    }

    protected <O> List<O> toListImpl(Filtermap<? super Node, ? extends O> filter) {
        Iterator<? extends O> iter = filter.filterMap(this.baseIterator());
        return IteratorUtil.toList(iter);
    }

    @Override
    public @Nullable T first() {
        return this.firstImpl(this.filter);
    }

    @Override
    public <R extends Node> @Nullable R first(Class<? extends R> r1Class) {
        return this.firstImpl(this.filter.thenCast(r1Class));
    }

    @Override
    public @Nullable T first(Predicate<? super T> predicate) {
        return this.firstImpl(this.filter.thenFilter(predicate));
    }

    @Override
    public @Nullable T last() {
        return this.lastImpl(this.filter);
    }

    @Override
    public List<T> toList() {
        return this.toListImpl(this.filter);
    }

    @Override
    public <R> List<R> toList(Function<? super T, ? extends R> mapper) {
        return this.toListImpl(this.filter.thenApply(mapper));
    }

    @Override
    public <R extends Node> @Nullable R last(Class<? extends R> rClass) {
        return this.lastImpl(this.filter.thenCast(rClass));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.node + "] -> " + this.toList();
    }

    protected abstract <S extends Node> NodeStream<S> copyWithFilter(Filtermap<Node, ? extends S> var1);

    static class ChildrenStream
    extends FilteredChildrenStream<Node> {
        ChildrenStream(@NonNull Node root, int low, int len) {
            super(root, Filtermap.NODE_IDENTITY, low, len);
        }

        @Override
        public @Nullable Node first() {
            return this.len > 0 ? this.node.getChild(this.low) : null;
        }

        @Override
        public @Nullable Node last() {
            return this.len > 0 ? this.node.getChild(this.low + this.len - 1) : null;
        }

        @Override
        public @Nullable Node get(int n) {
            AssertionUtil.requireNonNegative("n", n);
            return this.len > 0 && n < this.len ? this.node.getChild(this.low + n) : null;
        }

        @Override
        public NodeStream<Node> take(int maxSize) {
            AssertionUtil.requireNonNegative("maxSize", maxSize);
            return StreamImpl.sliceChildren(this.node, this.filter, this.low, Math.min(maxSize, this.len));
        }

        @Override
        public NodeStream<Node> drop(int n) {
            AssertionUtil.requireNonNegative("n", n);
            if (n == 0) {
                return this;
            }
            int newLow = Math.min(this.low + n, this.node.getNumChildren());
            int newLen = Math.max(this.len - n, 0);
            return StreamImpl.sliceChildren(this.node, this.filter, newLow, newLen);
        }

        @Override
        public NodeStream<Node> dropLast(int n) {
            AssertionUtil.requireNonNegative("n", n);
            if (n == 0) {
                return this;
            }
            return this.take(Math.max(this.len - n, 0));
        }

        @Override
        public boolean nonEmpty() {
            return this.len > 0;
        }

        @Override
        public int count() {
            return this.len;
        }

        @Override
        public String toString() {
            return "Slice[" + this.node + ", " + this.low + ".." + (this.low + this.len) + "] -> " + this.toList();
        }
    }

    static class FilteredChildrenStream<T extends Node>
    extends AxisStream<T> {
        final int low;
        final int len;

        FilteredChildrenStream(@NonNull Node root, Filtermap<Node, ? extends T> filtermap, int low, int len) {
            super(root, filtermap);
            this.low = low;
            this.len = len;
        }

        @Override
        public <R extends Node> NodeStream<R> flatMap(Function<? super T, ? extends @Nullable NodeStream<? extends R>> mapper) {
            return StreamImpl.fromNonNullList(this.toList()).flatMap(mapper);
        }

        @Override
        protected <S extends Node> NodeStream<S> copyWithFilter(Filtermap<Node, ? extends S> filterMap) {
            return new FilteredChildrenStream<S>(this.node, filterMap, this.low, this.len);
        }

        @Override
        public Spliterator<T> spliterator() {
            return Spliterators.spliterator(this.iterator(), (long)this.count(), 80);
        }

        @Override
        protected Iterator<Node> baseIterator() {
            return TraversalUtils.childrenIterator(this.node, this.low, this.low + this.len);
        }

        @Override
        protected <O extends Node> @Nullable O firstImpl(Filtermap<? super Node, ? extends O> filter) {
            return TraversalUtils.getFirstChildMatching(this.node, filter, this.low, this.len);
        }

        @Override
        protected <O extends Node> @Nullable O lastImpl(Filtermap<? super Node, ? extends O> filter) {
            return TraversalUtils.getLastChildMatching(this.node, filter, this.low, this.len);
        }

        @Override
        public int count() {
            return TraversalUtils.countChildrenMatching(this.node, this.filter, this.low, this.len);
        }

        @Override
        public boolean nonEmpty() {
            return this.first() != null;
        }

        @Override
        protected <O> List<O> toListImpl(Filtermap<? super Node, ? extends O> filter) {
            return TraversalUtils.findChildrenMatching(this.node, filter, this.low, this.len);
        }

        @Override
        public NodeStream<T> take(int maxSize) {
            AssertionUtil.requireNonNegative("maxSize", maxSize);
            if (maxSize == 1) {
                return NodeStream.of(TraversalUtils.getFirstChildMatching(this.node, this.filter, this.low, this.len));
            }
            List matching = TraversalUtils.findChildrenMatching(this.node, this.filter, this.low, this.len, maxSize);
            return StreamImpl.fromNonNullList(matching);
        }

        @Override
        public NodeStream<T> drop(int n) {
            AssertionUtil.requireNonNegative("n", n);
            if (n == 0) {
                return this;
            }
            return StreamImpl.fromNonNullList(this.toList()).drop(n);
        }

        @Override
        public String toString() {
            return "FilteredSlice[" + this.node + ", " + this.low + ".." + (this.low + this.len) + "] -> " + this.toList();
        }
    }

    static final class DescendantOrSelfStream
    extends FilteredDescendantOrSelfStream<Node> {
        DescendantOrSelfStream(Node node, TreeWalker walker) {
            super(node, walker, Filtermap.NODE_IDENTITY);
        }

        @Override
        public NodeStream.DescendantNodeStream<Node> crossFindBoundaries(boolean cross) {
            return new DescendantOrSelfStream(this.node, this.walker.crossFindBoundaries(cross));
        }

        @Override
        public @Nullable Node first() {
            return this.node;
        }

        @Override
        public boolean nonEmpty() {
            return true;
        }
    }

    static class FilteredDescendantOrSelfStream<T extends Node>
    extends DescendantStreamBase<T> {
        FilteredDescendantOrSelfStream(Node node, TreeWalker walker, Filtermap<Node, ? extends T> filtermap) {
            super(node, walker, filtermap);
        }

        @Override
        public Iterator<Node> baseIterator() {
            return this.walker.descendantOrSelfIterator(this.node);
        }

        @Override
        protected <S extends Node> NodeStream.DescendantNodeStream<S> copyWithWalker(Filtermap<Node, ? extends S> filterMap, TreeWalker walker) {
            return new FilteredDescendantOrSelfStream<S>(this.node, walker, filterMap);
        }

        @Override
        protected <O> List<O> toListImpl(Filtermap<? super Node, ? extends O> filter) {
            ArrayList<O> result = new ArrayList<O>();
            O top = filter.apply(this.node);
            if (top != null) {
                result.add(top);
            }
            this.walker.findDescendantsMatching(this.node, filter, result);
            return result;
        }
    }

    static class DescendantStream
    extends FilteredDescendantStream<Node> {
        DescendantStream(Node node, TreeWalker walker) {
            super(node, walker, Filtermap.NODE_IDENTITY);
        }

        @Override
        public NodeStream.DescendantNodeStream<Node> crossFindBoundaries(boolean cross) {
            return new DescendantStream(this.node, this.walker.crossFindBoundaries(cross));
        }

        @Override
        public boolean nonEmpty() {
            return this.node.getNumChildren() > 0;
        }
    }

    static class FilteredDescendantStream<T extends Node>
    extends DescendantStreamBase<T> {
        FilteredDescendantStream(Node node, TreeWalker walker, Filtermap<Node, ? extends T> target) {
            super(node, walker, target);
        }

        @Override
        protected Iterator<Node> baseIterator() {
            return this.walker.descendantIterator(this.node);
        }

        @Override
        protected <S extends Node> NodeStream.DescendantNodeStream<S> copyWithWalker(Filtermap<Node, ? extends S> filterMap, TreeWalker walker) {
            return new FilteredDescendantStream<S>(this.node, walker, filterMap);
        }

        @Override
        protected <O extends Node> @Nullable O firstImpl(Filtermap<? super Node, ? extends O> filter) {
            return this.walker.getFirstDescendantOfType(this.node, filter);
        }

        @Override
        public boolean nonEmpty() {
            return this.walker.getFirstDescendantOfType(this.node, this.filter) != null;
        }

        @Override
        protected <O> List<O> toListImpl(Filtermap<? super Node, ? extends O> filter) {
            return this.walker.findDescendantsMatching(this.node, filter);
        }
    }

    static abstract class DescendantStreamBase<T extends Node>
    extends AxisStream<T>
    implements NodeStream.DescendantNodeStream<T> {
        final TreeWalker walker;

        DescendantStreamBase(@NonNull Node root, TreeWalker walker, Filtermap<Node, ? extends T> filter) {
            super(root, filter);
            this.walker = walker;
        }

        protected abstract <S extends Node> NodeStream.DescendantNodeStream<S> copyWithWalker(Filtermap<Node, ? extends S> var1, TreeWalker var2);

        @Override
        public NodeStream.DescendantNodeStream<T> crossFindBoundaries(boolean cross) {
            return this.walker.isCrossFindBoundaries() == cross ? this : this.copyWithWalker(this.filter, this.walker.crossFindBoundaries(cross));
        }

        @Override
        protected <S extends Node> NodeStream<S> copyWithFilter(Filtermap<Node, ? extends S> filterMap) {
            return this.copyWithWalker(filterMap, this.walker);
        }
    }

    static class AncestorOrSelfStream
    extends FilteredAncestorOrSelfStream<Node> {
        AncestorOrSelfStream(@NonNull Node node) {
            super(node, Filtermap.NODE_IDENTITY);
        }

        @Override
        public @Nullable Node first() {
            return this.node;
        }

        @Override
        public boolean nonEmpty() {
            return true;
        }

        @Override
        public @Nullable Node last() {
            Node last = this.node;
            while (last.getParent() != null) {
                last = last.getParent();
            }
            return last;
        }
    }

    static class FilteredAncestorOrSelfStream<T extends Node>
    extends AxisStream<T> {
        FilteredAncestorOrSelfStream(@NonNull T node, Filtermap<Node, ? extends T> target) {
            super((Node)node, target);
        }

        @Override
        protected Iterator<Node> baseIterator() {
            return new AncestorOrSelfIterator(this.node);
        }

        @Override
        public NodeStream<T> drop(int n) {
            AssertionUtil.requireNonNegative("n", n);
            if (n == 0) {
                return this;
            }
            Object nth = this.get(n);
            return StreamImpl.ancestorsOrSelf(nth, this.filter);
        }

        @Override
        protected <S extends Node> NodeStream<S> copyWithFilter(Filtermap<Node, ? extends S> filterMap) {
            S newFirst = TraversalUtils.getFirstParentOrSelfMatching(this.node, filterMap);
            if (newFirst == null) {
                return StreamImpl.empty();
            }
            return new FilteredAncestorOrSelfStream<S>(newFirst, filterMap);
        }

        @Override
        public @Nullable T first() {
            return (T)this.node;
        }

        @Override
        public boolean nonEmpty() {
            return true;
        }

        @Override
        protected <O extends Node> @Nullable O firstImpl(Filtermap<? super Node, ? extends O> filter) {
            return TraversalUtils.getFirstParentOrSelfMatching(this.node, filter);
        }
    }
}

