/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.ast.impl.javacc.AbstractJjtreeNode;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;

public final class JjtreeBuilder<N extends AbstractJjtreeNode<N, ?>> {
    private final List<N> nodes = new ArrayList<N>();
    private final List<Integer> marks = new ArrayList<Integer>();
    private int sp = 0;
    private int mk = 0;
    private boolean nodeCreated;
    private int numPendingInjection;

    public boolean nodeCreated() {
        return this.nodeCreated;
    }

    public void reset() {
        this.nodes.clear();
        this.marks.clear();
        this.sp = 0;
        this.mk = 0;
    }

    public N rootNode() {
        return (N)((AbstractJjtreeNode)this.nodes.get(0));
    }

    public N peekNode(int n) {
        return (N)((AbstractJjtreeNode)this.nodes.get(this.nodes.size() - n - 1));
    }

    public boolean isInjectionPending() {
        return this.numPendingInjection > 0;
    }

    public void injectRight(int n) {
        this.numPendingInjection = n;
    }

    public void pushNode(N n) {
        this.nodes.add(n);
        ++this.sp;
    }

    public N popNode() {
        --this.sp;
        if (this.sp < this.mk) {
            this.mk = this.marks.remove(this.marks.size() - 1);
        }
        return (N)((AbstractJjtreeNode)this.nodes.remove(this.nodes.size() - 1));
    }

    public N peekNode() {
        return (N)((AbstractJjtreeNode)this.nodes.get(this.nodes.size() - 1));
    }

    public int nodeArity() {
        return this.sp - this.mk;
    }

    public void clearNodeScope(N n) {
        while (this.sp > this.mk) {
            this.popNode();
        }
        this.mk = this.marks.remove(this.marks.size() - 1);
    }

    public void openNodeScope(N n, JavaccToken firstToken) {
        this.marks.add(this.mk);
        this.mk = this.sp;
        if (this.isInjectionPending()) {
            this.mk -= this.numPendingInjection;
            this.numPendingInjection = 0;
        }
        ((AbstractJjtreeNode)n).setFirstToken(firstToken);
        ((AbstractJjtreeNode)n).jjtOpen();
    }

    public void closeNodeScope(N n, int num, JavaccToken lastToken) {
        int a = this.nodeArity();
        this.mk = this.marks.remove(this.marks.size() - 1);
        AbstractJjtreeNode child = null;
        int i = num;
        while (i-- > 0) {
            child = (AbstractJjtreeNode)this.popNode();
            ((AbstractJjtreeNode)n).addChild(child, i);
        }
        if (child != null && num > a) {
            ((AbstractJjtreeNode)n).setFirstToken(child.getFirstToken());
        }
        this.closeImpl(n, lastToken);
    }

    public void closeNodeScope(N n, boolean condition, JavaccToken lastToken) {
        if (condition) {
            int a = this.nodeArity();
            this.mk = this.marks.remove(this.marks.size() - 1);
            while (a-- > 0) {
                ((AbstractJjtreeNode)n).addChild(this.popNode(), a);
            }
            this.closeImpl(n, lastToken);
        } else {
            this.mk = this.marks.remove(this.marks.size() - 1);
            this.nodeCreated = false;
        }
    }

    private void closeImpl(N n, JavaccToken lastToken) {
        if (lastToken.getNext() == ((AbstractJjtreeNode)n).getFirstToken()) {
            JavaccToken implicit = JavaccToken.implicitBefore(lastToken.getNext());
            ((AbstractJjtreeNode)n).setFirstToken(implicit);
            ((AbstractJjtreeNode)n).setLastToken(implicit);
        } else {
            ((AbstractJjtreeNode)n).setLastToken(lastToken);
        }
        ((AbstractJjtreeNode)n).jjtClose();
        this.pushNode(n);
        this.nodeCreated = true;
    }
}

