/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Language
extends Comparable<Language> {
    public String getName();

    public String getShortName();

    public String getId();

    @Experimental
    default public @Nullable String getBaseLanguageId() {
        return null;
    }

    @Experimental
    default public boolean isDialectOf(Language language) {
        AssertionUtil.requireParamNotNull("language", language);
        String base = this.getBaseLanguageId();
        if (base == null) {
            return false;
        }
        return base.equals(language.getId());
    }

    public List<String> getExtensions();

    default public boolean hasExtension(String extensionWithoutDot) {
        return this.getExtensions().contains(extensionWithoutDot);
    }

    public List<LanguageVersion> getVersions();

    default public LanguageVersion getLatestVersion() {
        List<LanguageVersion> versions = this.getVersions();
        return versions.get(versions.size() - 1);
    }

    public Set<String> getVersionNamesAndAliases();

    default public boolean hasVersion(String version) {
        return this.getVersion(version) != null;
    }

    default public @Nullable LanguageVersion getVersion(String version) {
        for (LanguageVersion v : this.getVersions()) {
            if (!v.getVersion().equals(version)) continue;
            return v;
        }
        return null;
    }

    public @NonNull LanguageVersion getDefaultVersion();

    default public LanguagePropertyBundle newPropertyBundle() {
        return new LanguagePropertyBundle(this);
    }

    public Set<String> getDependencies();
}

