/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.document.FileId;

public class TokenEntry
implements Comparable<TokenEntry> {
    private static final int EOF = 0;
    private final FileId fileId;
    private final int beginLine;
    private final int beginColumn;
    private final int endColumn;
    private final int endLine;
    private int index;
    private int identifier;
    private int hashCode;

    TokenEntry(FileId fileId, int line, int column) {
        assert (this.isOk(line) && this.isOk(column)) : "Coordinates are 1-based";
        this.identifier = 0;
        this.fileId = fileId;
        this.beginLine = line;
        this.beginColumn = column;
        this.endLine = line;
        this.endColumn = column;
    }

    TokenEntry(int imageId, FileId fileId, int beginLine, int beginColumn, int endLine, int endColumn, int index) {
        assert (this.isOk(beginLine) && this.isOk(beginColumn) && this.isOk(endLine) && this.isOk(endColumn)) : "Coordinates are 1-based";
        assert (imageId != 0);
        this.fileId = fileId;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.identifier = imageId;
        this.index = index;
    }

    public boolean isEof() {
        return this.identifier == 0;
    }

    private boolean isOk(int coord) {
        return coord >= 1;
    }

    FileId getFileId() {
        return this.fileId;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    int getIdentifier() {
        return this.identifier;
    }

    int getIndex() {
        return this.index;
    }

    public int hashCode() {
        return this.hashCode;
    }

    void setHashCode(int hashCode) {
        this.hashCode = hashCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenEntry)) {
            return false;
        }
        TokenEntry other = (TokenEntry)o;
        if (other.isEof() != this.isEof()) {
            return false;
        }
        if (this.isEof()) {
            return other.getFileId().equals(this.getFileId());
        }
        return other.hashCode == this.hashCode;
    }

    @Override
    public int compareTo(TokenEntry other) {
        return this.getIndex() - other.getIndex();
    }

    final void setImageIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public String getImage(Tokens tokens) {
        if (this.isEof()) {
            return "EOF";
        }
        String image = tokens.imageFromId(this.identifier);
        return image == null ? "--unknown--" : image;
    }

    public String toString() {
        if (this.isEof()) {
            return "EOF";
        }
        return Integer.toString(this.identifier);
    }
}

