/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.TokenEntry;

class MatchCollector {
    private final Map<Integer, List<Match>> matchTree = new TreeMap<Integer, List<Match>>();
    private final Map<Integer, BitSet> tokenMatchSets = new HashMap<Integer, BitSet>();
    private final MatchAlgorithm ma;

    MatchCollector(MatchAlgorithm ma) {
        this.ma = ma;
    }

    public void collect(List<TokenEntry> marks) {
        int skipped;
        for (int i = 0; i < marks.size() - 1; i += skipped + 1) {
            skipped = 0;
            TokenEntry mark1 = marks.get(i);
            for (int j = i + 1; j < marks.size(); ++j) {
                int dupes;
                TokenEntry mark2 = marks.get(j);
                int diff = mark1.getIndex() - mark2.getIndex();
                if (-diff < this.ma.getMinimumTileSize()) {
                    ++skipped;
                    continue;
                }
                if (this.hasPreviousDupe(mark1, mark2) || (dupes = this.countDuplicateTokens(mark1, mark2)) < this.ma.getMinimumTileSize() || diff + dupes >= 1) continue;
                this.reportMatch(mark1, mark2, dupes);
            }
        }
    }

    private void reportMatch(TokenEntry mark1, TokenEntry mark2, int dupes) {
        if (this.tokenMatchSets.computeIfAbsent(mark1.getIndex(), i -> new BitSet()).get(mark2.getIndex())) {
            return;
        }
        int lowestKey = this.tokenMatchSets.get(mark1.getIndex()).stream().reduce(mark1.getIndex(), Math::min);
        List matches = this.matchTree.computeIfAbsent(lowestKey, i -> new ArrayList());
        Iterator matchIterator = matches.iterator();
        block0: while (matchIterator.hasNext()) {
            Match m = (Match)matchIterator.next();
            for (Mark otherMark : m.getMarkSet()) {
                TokenEntry otherEnd = otherMark.getToken();
                if (otherEnd.getIndex() == mark1.getIndex()) continue;
                if (otherEnd.getIndex() < mark2.getIndex() && otherEnd.getIndex() + m.getTokenCount() >= mark2.getIndex() + dupes) {
                    return;
                }
                if (mark2.getIndex() < otherEnd.getIndex() && mark2.getIndex() + dupes >= otherEnd.getIndex() + m.getTokenCount()) {
                    matchIterator.remove();
                    continue block0;
                }
                if (dupes != m.getTokenCount()) continue;
                m.iterator().forEachRemaining(other -> this.registerTokenMatch(other.getToken(), mark2));
                m.addMark(mark2);
                return;
            }
        }
        matches.add(new Match(dupes, mark1, mark2));
        this.registerTokenMatch(mark1, mark2);
    }

    private void registerTokenMatch(TokenEntry mark1, TokenEntry mark2) {
        this.tokenMatchSets.computeIfAbsent(mark1.getIndex(), i -> new BitSet()).set(mark2.getIndex());
        this.tokenMatchSets.computeIfAbsent(mark2.getIndex(), i -> new BitSet()).set(mark1.getIndex());
    }

    List<Match> getMatches() {
        return this.matchTree.values().stream().reduce(new ArrayList(), (acc, matches) -> {
            acc.addAll(matches);
            return acc;
        });
    }

    private boolean hasPreviousDupe(TokenEntry mark1, TokenEntry mark2) {
        return mark1.getIndex() != 0 && !this.matchEnded(this.ma.tokenAt(-1, mark1), this.ma.tokenAt(-1, mark2));
    }

    private int countDuplicateTokens(TokenEntry mark1, TokenEntry mark2) {
        int index = 0;
        while (!this.matchEnded(this.ma.tokenAt(index, mark1), this.ma.tokenAt(index, mark2))) {
            ++index;
        }
        return index;
    }

    private boolean matchEnded(TokenEntry token1, TokenEntry token2) {
        return token1.getIdentifier() != token2.getIdentifier() || token1.isEof() || token2.isEof();
    }
}

