/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.sourceforge.pmd.cpd.CPDConfiguration;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.CpdCapableLanguage;
import net.sourceforge.pmd.cpd.CpdLanguageProperties;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.SourceManager;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.internal.util.FileCollectionUtil;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.ast.FileAnalysisException;
import net.sourceforge.pmd.lang.ast.LexException;
import net.sourceforge.pmd.lang.document.FileCollector;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.lang.document.InternalApiBridge;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CpdAnalysis
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpdAnalysis.class);
    private final CPDConfiguration configuration;
    private final FileCollector files;
    private final PmdReporter reporter;
    private final Map<FileId, Integer> numberOfTokensPerFile = new HashMap<FileId, Integer>();
    private final List<Report.ProcessingError> processingErrors = new ArrayList<Report.ProcessingError>();
    private final @Nullable CPDReportRenderer renderer;
    private @NonNull CPDListener listener = new CPDNullListener();

    private CpdAnalysis(CPDConfiguration config) {
        this.configuration = config;
        this.reporter = config.getReporter();
        this.files = InternalApiBridge.newCollector(config.getLanguageVersionDiscoverer(), this.reporter);
        this.renderer = config.getCPDReportRenderer();
        FileCollectionUtil.collectFiles(config, this.files());
        for (Language language : config.getLanguageRegistry()) {
            this.setLanguageProperties(language, config);
        }
    }

    public static CpdAnalysis create(CPDConfiguration config) {
        return new CpdAnalysis(config);
    }

    private static <T> void setPropertyIfMissing(PropertyDescriptor<T> prop, LanguagePropertyBundle sink, T value) {
        if (sink.hasDescriptor(prop) && !sink.isPropertyOverridden(prop)) {
            sink.setProperty(prop, value);
        }
    }

    private void setLanguageProperties(Language language, CPDConfiguration configuration) {
        LanguagePropertyBundle props = configuration.getLanguageProperties(language);
        CpdAnalysis.setPropertyIfMissing(CpdLanguageProperties.CPD_ANONYMIZE_LITERALS, props, configuration.isIgnoreLiterals());
        CpdAnalysis.setPropertyIfMissing(CpdLanguageProperties.CPD_ANONYMIZE_IDENTIFIERS, props, configuration.isIgnoreIdentifiers());
        CpdAnalysis.setPropertyIfMissing(CpdLanguageProperties.CPD_IGNORE_METADATA, props, configuration.isIgnoreAnnotations());
        CpdAnalysis.setPropertyIfMissing(CpdLanguageProperties.CPD_IGNORE_IMPORTS, props, configuration.isIgnoreUsings());
        CpdAnalysis.setPropertyIfMissing(CpdLanguageProperties.CPD_IGNORE_LITERAL_SEQUENCES, props, configuration.isIgnoreLiteralSequences());
        CpdAnalysis.setPropertyIfMissing(CpdLanguageProperties.CPD_IGNORE_LITERAL_AND_IDENTIFIER_SEQUENCES, props, configuration.isIgnoreIdentifierAndLiteralSequences());
        if (!configuration.isNoSkipBlocks()) {
            PropertyDescriptor<?> skipBlocks = props.getPropertyDescriptor("cpdSkipBlocksPattern");
            CpdAnalysis.setPropertyIfMissing(skipBlocks, props, configuration.getSkipBlocksPattern());
        }
    }

    public FileCollector files() {
        return this.files;
    }

    public void setCpdListener(@Nullable CPDListener cpdListener) {
        if (cpdListener == null) {
            cpdListener = new CPDNullListener();
        }
        this.listener = cpdListener;
    }

    private int doTokenize(TextDocument document, CpdLexer cpdLexer, Tokens tokens) throws IOException, LexException {
        LOGGER.trace("Tokenizing {}", (Object)document.getFileId().getAbsolutePath());
        int lastTokenSize = tokens.size();
        CpdLexer.tokenize(cpdLexer, document, tokens);
        return tokens.size() - lastTokenSize - 1;
    }

    public void performAnalysis() {
        this.performAnalysis(r -> {});
    }

    public void performAnalysis(Consumer<CPDReport> consumer) {
        try (SourceManager sourceManager = new SourceManager(this.files.getCollectedFiles());){
            if (sourceManager.isEmpty()) {
                this.reporter.warn("No files to analyze. Check input paths and exclude parameters, use --debug to see file collection traces.", new Object[0]);
            }
            List<Match> matches = this.findMatches(sourceManager);
            if (this.shouldAbortEarlyBecauseOfProcessingErrors()) {
                this.reporter.error("Errors were detected while lexing source, exiting because --skip-lexical-errors is unset.", new Object[0]);
                return;
            }
            CPDReport cpdReport = new CPDReport(sourceManager, matches, this.numberOfTokensPerFile, this.processingErrors);
            if (this.renderer != null) {
                Path reportFilePath = this.configuration.getReportFilePath();
                String reportFileAsString = reportFilePath != null ? reportFilePath.toAbsolutePath().toString() : null;
                try (Writer writer = IOUtil.createWriter(Charset.defaultCharset(), reportFileAsString);){
                    this.renderer.render(cpdReport, writer);
                }
            }
            consumer.accept(cpdReport);
        }
        catch (IOException e) {
            this.reporter.errorEx("Exception while running CPD", e);
        }
    }

    private boolean shouldAbortEarlyBecauseOfProcessingErrors() {
        return !this.processingErrors.isEmpty() && !this.configuration.isSkipLexicalErrors();
    }

    private List<Match> findMatches(SourceManager sourceManager) {
        Tokens tokens = this.tokenizeFiles(sourceManager);
        if (this.shouldAbortEarlyBecauseOfProcessingErrors()) {
            return Collections.emptyList();
        }
        LOGGER.debug("Running match algorithm on {} files...", (Object)sourceManager.size());
        MatchAlgorithm matchAlgorithm = new MatchAlgorithm(tokens, this.configuration.getMinimumTileSize());
        List<Match> matches = matchAlgorithm.findMatches(this.listener, sourceManager);
        LOGGER.debug("Finished: {} duplicates found", (Object)matches.size());
        return matches;
    }

    private Tokens tokenizeFiles(SourceManager sourceManager) {
        Map<Language, CpdLexer> tokenizers = sourceManager.getTextFiles().stream().map(it -> it.getLanguageVersion().getLanguage()).distinct().filter(it -> it instanceof CpdCapableLanguage).collect(Collectors.toMap(lang -> lang, lang -> ((CpdCapableLanguage)lang).createCpdLexer(this.configuration.getLanguageProperties((Language)lang))));
        Tokens tokens = new Tokens();
        for (TextFile textFile : sourceManager.getTextFiles()) {
            TextDocument textDocument = sourceManager.get(textFile);
            Tokens.State savedState = tokens.savePoint();
            try {
                int newTokens = this.doTokenize(textDocument, tokenizers.get(textFile.getLanguageVersion().getLanguage()), tokens);
                this.numberOfTokensPerFile.put(textDocument.getFileId(), newTokens);
                this.listener.addedFile(1);
            }
            catch (IOException | FileAnalysisException e) {
                if (e instanceof FileAnalysisException) {
                    ((FileAnalysisException)((Object)e)).setFileId(textFile.getFileId());
                }
                String message = this.configuration.isSkipLexicalErrors() ? "Skipping file" : "Error while tokenizing";
                this.reporter.errorEx(message, (Throwable)e);
                this.processingErrors.add(new Report.ProcessingError((Throwable)e, textFile.getFileId()));
                savedState.restore(tokens);
            }
        }
        return tokens;
    }

    @Override
    public void close() throws IOException {
    }
}

