/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguagePropertyBundle;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionDiscoverer;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractConfiguration {
    private final List<Path> relativizeRoots = new ArrayList<Path>();
    private URI inputUri;
    private Charset sourceEncoding = Charset.forName(System.getProperty("file.encoding"));
    private final Map<Language, LanguagePropertyBundle> langProperties = new HashMap<Language, LanguagePropertyBundle>();
    private final LanguageRegistry langRegistry;
    private PmdReporter reporter;
    private final LanguageVersionDiscoverer languageVersionDiscoverer;
    private LanguageVersion forceLanguageVersion;
    private @NonNull List<Path> inputPaths = new ArrayList<Path>();
    private Path inputFilePath;
    private Path ignoreFilePath;
    private List<Path> excludes = new ArrayList<Path>();
    private boolean collectRecursive = true;
    private Path reportFile;
    private boolean failOnViolation = true;
    private boolean failOnError = true;

    protected AbstractConfiguration(LanguageRegistry languageRegistry, PmdReporter messageReporter) {
        this.langRegistry = Objects.requireNonNull(languageRegistry);
        this.languageVersionDiscoverer = new LanguageVersionDiscoverer(languageRegistry);
        this.reporter = Objects.requireNonNull(messageReporter);
    }

    public Charset getSourceEncoding() {
        return this.sourceEncoding;
    }

    public void setSourceEncoding(Charset sourceEncoding) {
        this.sourceEncoding = Objects.requireNonNull(sourceEncoding);
    }

    public @NonNull LanguagePropertyBundle getLanguageProperties(Language language) {
        this.checkLanguageIsRegistered(language);
        return this.langProperties.computeIfAbsent(language, Language::newPropertyBundle);
    }

    void checkLanguageIsRegistered(Language language) {
        if (!this.langRegistry.getLanguages().contains(language)) {
            throw new IllegalArgumentException("Language '" + language.getId() + "' is not registered in " + this.getLanguageRegistry());
        }
        this.checkLanguageIsAcceptable(language);
    }

    public LanguageRegistry getLanguageRegistry() {
        return this.langRegistry;
    }

    public @NonNull PmdReporter getReporter() {
        return this.reporter;
    }

    public void setReporter(@NonNull PmdReporter reporter) {
        AssertionUtil.requireParamNotNull("reporter", reporter);
        this.reporter = reporter;
    }

    public LanguageVersionDiscoverer getLanguageVersionDiscoverer() {
        return this.languageVersionDiscoverer;
    }

    public LanguageVersion getForceLanguageVersion() {
        return this.forceLanguageVersion;
    }

    public boolean isForceLanguageVersion() {
        return this.forceLanguageVersion != null;
    }

    public void setForceLanguageVersion(@Nullable LanguageVersion forceLanguageVersion) {
        if (forceLanguageVersion != null) {
            this.checkLanguageIsRegistered(forceLanguageVersion.getLanguage());
        }
        this.forceLanguageVersion = forceLanguageVersion;
        this.languageVersionDiscoverer.setForcedVersion(forceLanguageVersion);
    }

    public void setOnlyRecognizeLanguage(Language lang) {
        AssertionUtil.requireParamNotNull("language", lang);
        this.checkLanguageIsRegistered(lang);
        this.languageVersionDiscoverer.onlyRecognizeLanguages(LanguageRegistry.singleton(lang));
    }

    public void setDefaultLanguageVersion(LanguageVersion languageVersion) {
        Objects.requireNonNull(languageVersion);
        this.checkLanguageIsRegistered(languageVersion.getLanguage());
        this.languageVersionDiscoverer.setDefaultLanguageVersion(languageVersion);
        this.getLanguageProperties(languageVersion.getLanguage()).setLanguageVersion(languageVersion.getVersion());
    }

    public void setDefaultLanguageVersions(List<LanguageVersion> languageVersions) {
        for (LanguageVersion languageVersion : languageVersions) {
            this.setDefaultLanguageVersion(languageVersion);
        }
    }

    protected void checkLanguageIsAcceptable(Language lang) throws UnsupportedOperationException {
    }

    public @Nullable LanguageVersion getLanguageVersionOfFile(String fileName) {
        LanguageVersion forcedVersion = this.getForceLanguageVersion();
        if (forcedVersion != null) {
            return forcedVersion;
        }
        return this.languageVersionDiscoverer.getDefaultLanguageVersionForFile(fileName);
    }

    public void addRelativizeRoot(Path path) {
        this.relativizeRoots.add(Objects.requireNonNull(path));
        if (Files.isRegularFile(path, new LinkOption[0])) {
            throw new IllegalArgumentException("Relativize root should be a directory: " + path);
        }
    }

    public void addRelativizeRoots(List<Path> paths) {
        for (Path path : paths) {
            this.addRelativizeRoot(path);
        }
    }

    public List<Path> getRelativizeRoots() {
        return Collections.unmodifiableList(this.relativizeRoots);
    }

    public URI getUri() {
        return this.inputUri;
    }

    public void setInputUri(URI inputUri) {
        this.inputUri = inputUri;
    }

    public @NonNull List<Path> getInputPathList() {
        return Collections.unmodifiableList(this.inputPaths);
    }

    public void setInputPathList(List<Path> inputPaths) {
        AssertionUtil.requireContainsNoNullValue("input paths", inputPaths);
        this.inputPaths = new ArrayList<Path>(inputPaths);
    }

    public void addInputPath(@NonNull Path inputPath) {
        Objects.requireNonNull(inputPath);
        this.inputPaths.add(inputPath);
    }

    public @Nullable Path getInputFile() {
        return this.inputFilePath;
    }

    public @Nullable Path getIgnoreFile() {
        return this.ignoreFilePath;
    }

    public void setInputFilePath(Path inputFilePath) {
        this.inputFilePath = inputFilePath;
    }

    public void setIgnoreFilePath(Path ignoreFilePath) {
        this.ignoreFilePath = ignoreFilePath;
    }

    public List<Path> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(List<Path> excludes) {
        this.excludes = Objects.requireNonNull(excludes);
    }

    public boolean collectFilesRecursively() {
        return this.collectRecursive;
    }

    public void collectFilesRecursively(boolean collectRecursive) {
        this.collectRecursive = collectRecursive;
    }

    public @Nullable Path getReportFilePath() {
        return this.reportFile;
    }

    public void setReportFile(@Nullable Path reportFile) {
        this.reportFile = reportFile;
    }

    public boolean isFailOnViolation() {
        return this.failOnViolation;
    }

    public void setFailOnViolation(boolean failOnViolation) {
        this.failOnViolation = failOnViolation;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }
}

