/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypePrettyPrint;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVarSym;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.pcollections.HashTreePSet;
import org.pcollections.PSet;

public final class InferenceVar
implements SubstVar {
    private static final String NAMES = "abcdefghijklmnopqrstuvwxyz";
    private final InferenceContext ctx;
    private JTypeVar tvar;
    private final int id;
    private BoundSet boundSet = new BoundSet();
    private boolean hasNonTrivialBound;

    InferenceVar(InferenceContext ctx, JTypeVar tvar, int id) {
        this.ctx = ctx;
        this.tvar = tvar;
        this.id = id;
    }

    @Override
    public JTypeMirror withAnnotations(PSet<SymbolicValue.SymAnnot> newTypeAnnots) {
        return this;
    }

    @Override
    public PSet<SymbolicValue.SymAnnot> getTypeAnnotations() {
        return HashTreePSet.empty();
    }

    public String getName() {
        String prefix = this.isCaptured() ? "^" : "'";
        return prefix + NAMES.charAt(this.id % NAMES.length()) + this.generationNum();
    }

    @Override
    public TypeSystem getTypeSystem() {
        return this.ctx.ts;
    }

    public Set<JTypeMirror> getBounds(BoundKind kind) {
        return this.boundSet.bounds.getOrDefault((Object)kind, Collections.emptySet());
    }

    Set<JTypeMirror> getBounds(Set<BoundKind> kinds) {
        LinkedHashSet<JTypeMirror> bounds = new LinkedHashSet<JTypeMirror>();
        for (BoundKind k : kinds) {
            bounds.addAll(this.getBounds(k));
        }
        return bounds;
    }

    public void addBound(BoundKind kind, JTypeMirror type) {
        this.addBound(kind, type, false);
    }

    public void addPrimaryBound(BoundKind kind, JTypeMirror type) {
        this.addBound(kind, type, true);
    }

    private void addBound(BoundKind kind, JTypeMirror type, boolean isPrimaryBound) {
        if (this.isEquivalentTo(type)) {
            return;
        }
        if (kind == BoundKind.LOWER && type.isBottom()) {
            return;
        }
        if (this.boundSet.bounds.computeIfAbsent(kind, k -> new LinkedHashSet()).add(type)) {
            if (!isPrimaryBound) {
                this.hasNonTrivialBound = true;
            }
            this.ctx.onBoundAdded(this, kind, type, isPrimaryBound);
        }
    }

    boolean hasOnlyPrimaryBound() {
        return !this.hasNonTrivialBound;
    }

    @Nullable JTypeMirror getInst() {
        return this.boundSet.inst;
    }

    void setInst(JTypeMirror inst) {
        this.boundSet.inst = inst;
    }

    void substBounds(Function<? super SubstVar, ? extends JTypeMirror> substitution) {
        for (Map.Entry<BoundKind, Set<JTypeMirror>> entry : this.boundSet.bounds.entrySet()) {
            BoundKind kind = entry.getKey();
            Set<JTypeMirror> prevBounds = entry.getValue();
            LinkedHashSet<JTypeVisitable> newBounds = new LinkedHashSet<JTypeVisitable>();
            this.boundSet.bounds.put(kind, newBounds);
            for (JTypeMirror prev : prevBounds) {
                JTypeVisitable newBound = prev.subst((Function)substitution);
                if (newBound == prev || prevBounds.contains(newBound)) {
                    newBounds.add(newBound);
                    continue;
                }
                this.addBound(kind, (JTypeMirror)newBound);
            }
        }
        if (this.tvar.isCaptured()) {
            this.tvar = this.tvar.substInBounds(substitution);
        }
    }

    JTypeVar getBaseVar() {
        return this.tvar;
    }

    boolean isCaptured() {
        return this.tvar.isCaptured();
    }

    public boolean isEquivalentTo(JTypeMirror t) {
        return this == t || t instanceof InferenceVar && ((InferenceVar)t).boundSet == this.boundSet;
    }

    public boolean isSubtypeNoSideEffect(@NonNull JTypeMirror other) {
        return this.isEquivalentTo(other) || other.isTop();
    }

    public boolean isSupertypeNoSideEffect(@NonNull JTypeMirror other) {
        return this.isEquivalentTo(other) || other.isBottom();
    }

    void adoptAllBounds(InferenceVar candidate) {
        if (this.isEquivalentTo(candidate)) {
            return;
        }
        for (BoundKind kind : BoundKind.values()) {
            for (JTypeMirror bound : candidate.getBounds(kind)) {
                this.addBound(kind, bound);
            }
        }
        candidate.boundSet = this.boundSet;
        this.ctx.onIvarMerged(candidate, this);
    }

    @Override
    public @Nullable JTypeDeclSymbol getSymbol() {
        JTypeMirror inst = this.getInst();
        return inst != null ? inst.getSymbol() : new InferenceVarSym(this.ctx.ts, this);
    }

    @Override
    public JTypeMirror subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> subst) {
        return subst.apply(this);
    }

    @Override
    public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitInferenceVar(this, p);
    }

    @Override
    public String toString() {
        return TypePrettyPrint.prettyPrint(this);
    }

    private String generationNum() {
        int n = this.id / NAMES.length();
        return n == 0 ? "" : "" + n;
    }

    StringBuilder formatBounds(StringBuilder sb) {
        sb.append(" {");
        boolean any = false;
        for (BoundKind bk : BoundKind.ALL) {
            for (JTypeMirror bound : this.getBounds(bk)) {
                sb.append(any ? ", " : " ").append(bk.format(this, bound));
                any = true;
            }
        }
        sb.append(any ? " }" : "}");
        return sb;
    }

    private static final class BoundSet {
        JTypeMirror inst;
        Map<BoundKind, Set<JTypeMirror>> bounds = new EnumMap<BoundKind, Set<JTypeMirror>>(BoundKind.class);

        private BoundSet() {
        }
    }

    public static enum BoundKind {
        UPPER(" <: "){

            @Override
            public BoundKind complement() {
                return LOWER;
            }

            @Override
            public Set<BoundKind> complementSet(boolean eqIsAll) {
                return EQ_LOWER;
            }
        }
        ,
        EQ(" = "){

            @Override
            public BoundKind complement() {
                return this;
            }

            @Override
            public Set<BoundKind> complementSet(boolean eqIsAll) {
                return eqIsAll ? ALL : JUST_EQ;
            }
        }
        ,
        LOWER(" >: "){

            @Override
            public BoundKind complement() {
                return UPPER;
            }

            @Override
            public Set<BoundKind> complementSet(boolean eqIsAll) {
                return EQ_UPPER;
            }
        };

        static final Set<BoundKind> ALL;
        static final Set<BoundKind> EQ_LOWER;
        static final Set<BoundKind> EQ_UPPER;
        private static final Set<BoundKind> JUST_EQ;
        private final String sym;

        private BoundKind(String sym) {
            this.sym = sym;
        }

        public String format(JTypeMirror ivar, JTypeMirror bound) {
            return ivar + this.sym + bound;
        }

        public abstract BoundKind complement();

        public abstract Set<BoundKind> complementSet(boolean var1);

        String getSym() {
            return this.sym;
        }

        public String toString() {
            return this.sym;
        }

        static {
            ALL = EnumSet.allOf(BoundKind.class);
            EQ_LOWER = EnumSet.of(EQ, LOWER);
            EQ_UPPER = EnumSet.of(EQ, UPPER);
            JUST_EQ = Collections.singleton(EQ);
        }
    }
}

