/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.GraphUtil;

class Graph<T> {
    private static final int UNDEFINED = -1;
    private final Set<Vertex<T>> vertices = new LinkedHashSet<Vertex<T>>();
    private final Map<Vertex<T>, Set<Vertex<T>>> successors = new HashMap<Vertex<T>, Set<Vertex<T>>>();

    Graph() {
    }

    Vertex<T> addLeaf(T data) {
        Vertex v = new Vertex(this, Collections.singleton(data));
        this.vertices.add(v);
        return v;
    }

    void addEdge(Vertex<T> start, Vertex<T> end) {
        Objects.requireNonNull(end);
        Objects.requireNonNull(start);
        this.vertices.add(start);
        this.vertices.add(end);
        if (start == end) {
            return;
        }
        this.successors.computeIfAbsent(start, k -> new LinkedHashSet()).add(end);
    }

    Set<Vertex<T>> successorsOf(Vertex<T> node) {
        return this.successors.getOrDefault(node, Collections.emptySet());
    }

    Set<Vertex<T>> getVertices() {
        return this.vertices;
    }

    List<Set<T>> topologicalSort() {
        ArrayList<Set<T>> sorted = new ArrayList<Set<T>>(this.vertices.size());
        for (Vertex<T> n : this.vertices) {
            this.toposort(n, sorted);
        }
        return sorted;
    }

    private void toposort(Vertex<T> v, List<Set<T>> sorted) {
        if (((Vertex)v).mark) {
            return;
        }
        for (Vertex<T> w : this.successorsOf(v)) {
            this.toposort(w, sorted);
        }
        ((Vertex)v).mark = true;
        sorted.add(v.getData());
    }

    void mergeCycles() {
        TarjanState state = new TarjanState();
        for (Vertex<T> vertex : new ArrayList<Vertex<T>>(this.vertices)) {
            if (((Vertex)vertex).index != -1) continue;
            this.strongConnect(state, vertex);
        }
    }

    private void strongConnect(TarjanState<T> state, Vertex<T> v) {
        ((Vertex)v).index = state.index;
        ((Vertex)v).lowLink = state.index;
        ++state.index;
        state.stack.push(v);
        ((Vertex)v).onStack = true;
        for (Vertex<T> w : new ArrayList<Vertex<T>>(this.successorsOf(v))) {
            if (((Vertex)w).index == -1) {
                this.strongConnect(state, w);
                ((Vertex)v).lowLink = Math.min(((Vertex)w).lowLink, ((Vertex)v).lowLink);
                continue;
            }
            if (!((Vertex)w).onStack) continue;
            ((Vertex)v).lowLink = Math.min(((Vertex)v).lowLink, ((Vertex)w).index);
        }
        if (((Vertex)v).lowLink == ((Vertex)v).index) {
            Vertex w;
            do {
                w = state.stack.pop();
                w.onStack = false;
                ((Vertex)v).absorb(w);
            } while (w != v);
        }
    }

    void onAbsorb(Vertex<T> vertex, Vertex<T> toMerge) {
        Set succ = CollectionUtil.union(this.successorsOf(vertex), this.successorsOf(toMerge), (Collection[])new Collection[0]);
        succ.remove(toMerge);
        succ.remove(vertex);
        this.successors.put(vertex, succ);
        this.successors.remove(toMerge);
        this.vertices.remove(toMerge);
        this.successors.values().forEach(it -> it.remove(toMerge));
    }

    public String toString() {
        return GraphUtil.toDot(this.vertices, this::successorsOf, v -> GraphUtil.DotColor.BLACK, v -> ((Vertex)v).data.toString());
    }

    static final class Vertex<T> {
        private final Graph<T> owner;
        private final Set<T> data;
        private int index = -1;
        private int lowLink = -1;
        private boolean onStack = false;
        private boolean mark;

        private Vertex(Graph<T> owner, Set<T> data) {
            this.owner = owner;
            this.data = new LinkedHashSet<T>(data);
        }

        public Set<T> getData() {
            return this.data;
        }

        private void absorb(Vertex<T> toMerge) {
            if (this == toMerge) {
                return;
            }
            this.data.addAll(toMerge.data);
            this.owner.onAbsorb(this, toMerge);
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private static final class TarjanState<T> {
        int index;
        Deque<Vertex<T>> stack = new ArrayDeque<Vertex<T>>();

        private TarjanState() {
        }
    }

    static class UniqueGraph<T>
    extends Graph<T> {
        private final Map<T, Vertex<T>> vertexMap = new HashMap<T, Vertex<T>>();

        UniqueGraph() {
        }

        @Override
        Vertex<T> addLeaf(T data) {
            if (this.vertexMap.containsKey(data)) {
                return this.vertexMap.get(data);
            }
            Vertex<T> v = super.addLeaf(data);
            this.vertexMap.put(data, v);
            return v;
        }

        @Override
        void onAbsorb(Vertex<T> vertex, Vertex<T> toMerge) {
            super.onAbsorb(vertex, toMerge);
            for (T ivar : toMerge.getData()) {
                this.vertexMap.put(ivar, vertex);
            }
        }
    }
}

