/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.JTypeParameterSymbol;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.CaptureMatcher;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JIntersectionType;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.pcollections.PSet;

public final class TypePrettyPrint {
    private TypePrettyPrint() {
    }

    public static @NonNull String prettyPrint(@NonNull JTypeVisitable t) {
        return TypePrettyPrint.prettyPrint(t, new TypePrettyPrinter());
    }

    public static @NonNull String prettyPrintWithSimpleNames(@NonNull JTypeVisitable t) {
        return TypePrettyPrint.prettyPrint(t, new TypePrettyPrinter().qualifyNames(false));
    }

    public static String prettyPrint(@NonNull JTypeVisitable t, TypePrettyPrinter prettyPrinter) {
        t.acceptVisitor(PrettyPrintVisitor.INSTANCE, prettyPrinter);
        return prettyPrinter.consumeResult();
    }

    public static class TypePrettyPrinter {
        private final StringBuilder sb = new StringBuilder();
        private boolean printMethodHeader = true;
        private boolean printMethodReturnType = true;
        private OptionalBool printTypeVarBounds = OptionalBool.UNKNOWN;
        private boolean qualifyTvars = false;
        private boolean qualifyNames = true;
        private boolean isVarargs = false;
        private boolean printTypeAnnotations = true;
        private boolean qualifyAnnotations = false;

        StringBuilder append(char o) {
            return this.sb.append(o);
        }

        StringBuilder append(String o) {
            return this.sb.append(o);
        }

        public TypePrettyPrinter printMethodHeader(boolean printMethodHeader) {
            this.printMethodHeader = printMethodHeader;
            return this;
        }

        public TypePrettyPrinter printMethodResult(boolean printMethodResult) {
            this.printMethodReturnType = printMethodResult;
            return this;
        }

        public void printTypeVarBounds(OptionalBool printTypeVarBounds) {
            this.printTypeVarBounds = printTypeVarBounds;
        }

        public TypePrettyPrinter qualifyTvars(boolean qualifyTvars) {
            this.qualifyTvars = qualifyTvars;
            return this;
        }

        public TypePrettyPrinter qualifyAnnotations(boolean qualifyAnnotations) {
            this.qualifyAnnotations = qualifyAnnotations;
            return this;
        }

        public TypePrettyPrinter printAnnotations(boolean printAnnotations) {
            this.printTypeAnnotations = printAnnotations;
            return this;
        }

        public TypePrettyPrinter qualifyNames(boolean qualifyNames) {
            this.qualifyNames = qualifyNames;
            return this;
        }

        String consumeResult() {
            String result = this.sb.toString();
            this.sb.setLength(0);
            return result;
        }

        private void printTypeAnnotations(PSet<SymbolicValue.SymAnnot> annots) {
            if (this.printTypeAnnotations) {
                for (SymbolicValue.SymAnnot annot : annots) {
                    String name = this.qualifyAnnotations ? annot.getBinaryName() : annot.getSimpleName();
                    this.append('@').append(name).append(' ');
                }
            }
        }
    }

    private static final class PrettyPrintVisitor
    implements JTypeVisitor<Void, TypePrettyPrinter> {
        static final PrettyPrintVisitor INSTANCE = new PrettyPrintVisitor();

        private PrettyPrintVisitor() {
        }

        @Override
        public Void visit(JTypeMirror t, TypePrettyPrinter sb) {
            sb.printTypeAnnotations((PSet<SymbolicValue.SymAnnot>)t.getTypeAnnotations());
            sb.append(t.toString());
            return null;
        }

        @Override
        public Void visitClass(JClassType t, TypePrettyPrinter sb) {
            JClassType enclosing = t.getEnclosingType();
            boolean isAnon = t.getSymbol().isAnonymousClass();
            if (enclosing != null && !isAnon) {
                this.visitClass(enclosing, sb);
                sb.append('#');
            } else if (t.hasErasedSuperTypes() && !t.isRaw()) {
                sb.append("(erased) ");
            }
            sb.printTypeAnnotations((PSet<SymbolicValue.SymAnnot>)t.getTypeAnnotations());
            if (t.getSymbol().isUnresolved()) {
                sb.append('*');
            }
            if (enclosing != null && !isAnon || !sb.qualifyNames) {
                sb.append(t.getSymbol().getSimpleName());
            } else {
                sb.append(t.getSymbol().getBinaryName());
            }
            List<JTypeMirror> targs = t.getTypeArgs();
            if (t.isRaw() || targs.isEmpty()) {
                return null;
            }
            if (t.isGenericTypeDeclaration() && sb.printTypeVarBounds != OptionalBool.NO) {
                sb.printTypeVarBounds = OptionalBool.YES;
            }
            this.join(sb, targs, ", ", "<", ">");
            return null;
        }

        @Override
        public Void visitWildcard(JWildcardType t, TypePrettyPrinter sb) {
            sb.printTypeAnnotations((PSet<SymbolicValue.SymAnnot>)t.getTypeAnnotations());
            sb.append("?");
            if (t.isUnbounded()) {
                return null;
            }
            sb.append(t.isUpperBound() ? " extends " : " super ");
            t.getBound().acceptVisitor(this, sb);
            return null;
        }

        @Override
        public Void visitPrimitive(JPrimitiveType t, TypePrettyPrinter sb) {
            sb.printTypeAnnotations((PSet<SymbolicValue.SymAnnot>)t.getTypeAnnotations());
            sb.append(t.getSimpleName());
            return null;
        }

        @Override
        public Void visitTypeVar(JTypeVar t, TypePrettyPrinter sb) {
            JTypeParameterSymbol sym;
            if (t instanceof CaptureMatcher) {
                sb.append(t.toString());
                return null;
            }
            if (!t.isCaptured() && sb.qualifyTvars && (sym = t.getSymbol()) != null) {
                sb.append(sym.getDeclaringSymbol().getSimpleName());
                sb.append('#');
            }
            sb.printTypeAnnotations((PSet<SymbolicValue.SymAnnot>)t.getTypeAnnotations());
            sb.append(t.getName());
            if (sb.printTypeVarBounds == OptionalBool.YES) {
                sb.printTypeVarBounds = OptionalBool.NO;
                if (!t.getUpperBound().isTop()) {
                    sb.append(" extends ");
                    t.getUpperBound().acceptVisitor(this, sb);
                }
                if (!t.getLowerBound().isBottom()) {
                    sb.append(" super ");
                    t.getLowerBound().acceptVisitor(this, sb);
                }
                sb.printTypeVarBounds = OptionalBool.YES;
            }
            return null;
        }

        @Override
        public Void visitMethodType(JMethodSig t, TypePrettyPrinter sb) {
            if (sb.printMethodHeader) {
                t.getDeclaringType().acceptVisitor(this, sb);
                sb.append(".");
                if (t.isGeneric()) {
                    OptionalBool printBounds = sb.printTypeVarBounds;
                    if (printBounds != OptionalBool.NO) {
                        sb.printTypeVarBounds = OptionalBool.YES;
                    }
                    this.join(sb, t.getTypeParameters(), ", ", "<", "> ", false);
                    sb.printTypeVarBounds = printBounds;
                }
            }
            sb.append(t.getName());
            this.join(sb, t.getFormalParameters(), ", ", "(", ")", t.isVarargs());
            if (sb.printMethodReturnType) {
                sb.append(" -> ");
                t.getReturnType().acceptVisitor(this, sb);
            }
            return null;
        }

        @Override
        public Void visitIntersection(JIntersectionType t, TypePrettyPrinter sb) {
            return this.join(sb, t.getComponents(), " & ", "", "");
        }

        @Override
        public Void visitArray(JArrayType t, TypePrettyPrinter sb) {
            JTypeMirror component = t.getComponentType();
            if (component instanceof JIntersectionType) {
                sb.append("(");
            }
            boolean isVarargs = sb.isVarargs;
            sb.isVarargs = false;
            component.acceptVisitor(this, sb);
            if (component instanceof JIntersectionType) {
                sb.append(")");
            }
            sb.printTypeAnnotations((PSet<SymbolicValue.SymAnnot>)t.getTypeAnnotations());
            sb.append(isVarargs ? "..." : "[]");
            return null;
        }

        @Override
        public Void visitNullType(JTypeMirror t, TypePrettyPrinter sb) {
            sb.append("null");
            return null;
        }

        @Override
        public Void visitInferenceVar(InferenceVar t, TypePrettyPrinter sb) {
            sb.append(t.getName());
            return null;
        }

        private Void join(TypePrettyPrinter sb, List<? extends JTypeMirror> ts, String delim, String prefix, String suffix) {
            return this.join(sb, ts, delim, prefix, suffix, false);
        }

        private Void join(TypePrettyPrinter sb, List<? extends JTypeMirror> types, String delim, String prefix, String suffix, boolean isVarargs) {
            sb.isVarargs = false;
            boolean empty = types.isEmpty();
            sb.append(prefix);
            if (!empty) {
                for (int i = 0; i < types.size() - 1; ++i) {
                    types.get(i).acceptVisitor(this, sb);
                    sb.append(delim);
                }
                if (isVarargs) {
                    sb.isVarargs = true;
                }
                types.get(types.size() - 1).acceptVisitor(this, sb);
            }
            sb.append(suffix);
            return null;
        }
    }
}

