/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JClassType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JWildcardType;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;
import org.pcollections.ConsPStack;
import org.pcollections.PSet;

final class TypeAnnotationHelper {
    private TypeAnnotationHelper() {
    }

    static JTypeMirror applySinglePath(@NonNull JTypeMirror base, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
        return TypeAnnotationHelper.resolvePathStep(base, path, 0, annot);
    }

    private static JTypeMirror resolvePathStep(JTypeMirror t, @Nullable TypePath path, int i, SymbolicValue.SymAnnot annot) {
        if (t instanceof JClassType && ((JClassType)t).getEnclosingType() != null) {
            return TypeAnnotationHelper.handleEnclosingType((JClassType)t, path, i, annot);
        }
        return TypeAnnotationHelper.resolvePathStepNoInner(t, path, i, annot);
    }

    private static JTypeMirror resolvePathStepNoInner(JTypeMirror t, @Nullable TypePath path, int i, SymbolicValue.SymAnnot annot) {
        assert (path == null || path.getLength() == i || path.getStep(i) != 1);
        if (path == null || i == path.getLength()) {
            return t.addAnnotation(annot);
        }
        switch (path.getStep(i)) {
            case 3: {
                if (t instanceof JClassType) {
                    int typeArgIndex = path.getStepArgument(i);
                    JTypeMirror arg = ((JClassType)t).getTypeArgs().get(typeArgIndex);
                    JTypeMirror newArg = TypeAnnotationHelper.resolvePathStep(arg, path, i + 1, annot);
                    List<JTypeMirror> newArgs = TypeAnnotationHelper.replaceAtIndex(((JClassType)t).getTypeArgs(), typeArgIndex, newArg);
                    return ((JClassType)t).withTypeArguments(newArgs);
                }
                throw new IllegalArgumentException("Expected class type: " + t);
            }
            case 0: {
                if (t instanceof JArrayType) {
                    JTypeMirror component = ((JArrayType)t).getComponentType();
                    JTypeMirror newComponent = TypeAnnotationHelper.resolvePathStep(component, path, i + 1, annot);
                    return t.getTypeSystem().arrayType(newComponent).withAnnotations((PSet)t.getTypeAnnotations());
                }
                throw new IllegalArgumentException("Expected array type: " + t);
            }
            case 1: {
                throw new IllegalStateException("Should be handled elsewhere");
            }
            case 2: {
                if (t instanceof JWildcardType) {
                    JWildcardType wild = (JWildcardType)t;
                    JTypeMirror newBound = TypeAnnotationHelper.resolvePathStep(wild.getBound(), path, i + 1, annot);
                    return wild.getTypeSystem().wildcard(wild.isUpperBound(), newBound).withAnnotations((PSet)wild.getTypeAnnotations());
                }
                throw new IllegalArgumentException("Expected wilcard type: " + t);
            }
        }
        throw new IllegalArgumentException("Illegal path step for annotation TypePath" + i);
    }

    private static JClassType handleEnclosingType(JClassType t, @Nullable TypePath path, int i, SymbolicValue.SymAnnot annot) {
        List<JClassType> enclosingTypes = TypeAnnotationHelper.getEnclosingTypes(t);
        int selectionDepth = 0;
        while (path != null && path.getStep(i + selectionDepth) == 1) {
            ++selectionDepth;
        }
        int selectedTypeIndex = enclosingTypes.size() - 1 - selectionDepth;
        JClassType selectedT = enclosingTypes.get(selectedTypeIndex);
        JClassType rebuiltType = (JClassType)TypeAnnotationHelper.resolvePathStepNoInner(selectedT, path, i + selectionDepth, annot);
        for (int j = selectedTypeIndex - 1; j >= 0; --j) {
            JClassType nextInner = enclosingTypes.get(j);
            rebuiltType = rebuiltType.selectInner(nextInner.getSymbol(), nextInner.getTypeArgs(), nextInner.getTypeAnnotations());
        }
        return rebuiltType;
    }

    private static List<JClassType> getEnclosingTypes(JClassType t) {
        ArrayList<JClassType> enclosing = new ArrayList<JClassType>(1);
        do {
            enclosing.add(t);
        } while ((t = t.getEnclosingType()) != null);
        return enclosing;
    }

    static @NonNull List<JTypeMirror> replaceAtIndex(List<JTypeMirror> typeArgs, int typeArgIndex, JTypeMirror newArg) {
        if (typeArgs.size() == 1 && typeArgIndex == 0) {
            return ConsPStack.singleton((Object)newArg);
        }
        return ConsPStack.from(typeArgs).with(typeArgIndex, (Object)newArg);
    }

    static final class TypeAnnotationSetWithReferences {
        private final List<Triple<TypeReference, @Nullable TypePath, SymbolicValue.SymAnnot>> pathAndAnnot = new ArrayList<Triple<TypeReference, TypePath, SymbolicValue.SymAnnot>>();

        TypeAnnotationSetWithReferences() {
        }

        void add(TypeReference reference, @Nullable TypePath path, SymbolicValue.SymAnnot annot) {
            this.pathAndAnnot.add((Triple<TypeReference, TypePath, SymbolicValue.SymAnnot>)Triple.of((Object)reference, (Object)path, (Object)annot));
        }

        void forEach(TypeAnnotationConsumer consumer) {
            for (Triple<TypeReference, TypePath, SymbolicValue.SymAnnot> triple : this.pathAndAnnot) {
                consumer.acceptAnnotation((TypeReference)triple.getLeft(), (TypePath)triple.getMiddle(), (SymbolicValue.SymAnnot)triple.getRight());
            }
        }

        <T> T reduce(T init, TypeAnnotationReducer<T> consumer) {
            T acc = init;
            for (Triple<TypeReference, TypePath, SymbolicValue.SymAnnot> triple : this.pathAndAnnot) {
                acc = consumer.acceptAnnotation((TypeReference)triple.getLeft(), (TypePath)triple.getMiddle(), (SymbolicValue.SymAnnot)triple.getRight(), acc);
            }
            return acc;
        }

        public String toString() {
            return this.pathAndAnnot.toString();
        }

        @FunctionalInterface
        static interface TypeAnnotationConsumer {
            public boolean acceptAnnotation(TypeReference var1, @Nullable TypePath var2, SymbolicValue.SymAnnot var3);
        }

        @FunctionalInterface
        static interface TypeAnnotationReducer<T> {
            public T acceptAnnotation(TypeReference var1, @Nullable TypePath var2, SymbolicValue.SymAnnot var3, T var4);
        }
    }

    static final class TypeAnnotationSet {
        private final List<Pair<@Nullable TypePath, SymbolicValue.SymAnnot>> pathAndAnnot = new ArrayList<Pair<TypePath, SymbolicValue.SymAnnot>>();

        TypeAnnotationSet() {
        }

        void add(@Nullable TypePath path, SymbolicValue.SymAnnot annot) {
            this.pathAndAnnot.add((Pair<TypePath, SymbolicValue.SymAnnot>)Pair.of((Object)path, (Object)annot));
        }

        JTypeMirror decorate(@NonNull JTypeMirror base) {
            for (Pair<TypePath, SymbolicValue.SymAnnot> pair : this.pathAndAnnot) {
                base = TypeAnnotationHelper.applySinglePath(base, (TypePath)pair.getLeft(), (SymbolicValue.SymAnnot)pair.getRight());
            }
            return base;
        }
    }
}

