/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import net.sourceforge.pmd.lang.java.symbols.internal.asm.AnnotationBuilderVisitor;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.AsmSymbolResolver;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ExecutableStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.FieldStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.MethodInfoVisitor;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.RecordComponentStub;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;

class ClassStubBuilder
extends ClassVisitor {
    private final ClassStub myStub;
    private final String myInternalName;
    private final AsmSymbolResolver resolver;
    private boolean isAnonOrLocalClass = false;
    private boolean isInnerNonStaticClass = false;

    ClassStubBuilder(ClassStub stub, AsmSymbolResolver resolver) {
        super(589824);
        this.myStub = stub;
        this.myInternalName = stub.getInternalName();
        this.resolver = resolver;
    }

    public void visit(int version, int access, String internalName, @Nullable String signature, String superName, String[] interfaces) {
        this.myStub.setModifiers(access, true);
        this.myStub.setHeader(signature, superName, interfaces);
    }

    public AnnotationBuilderVisitor visitAnnotation(String descriptor, boolean visible) {
        return new AnnotationBuilderVisitor(this.myStub, this.resolver, visible, descriptor);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        final RecordComponentStub componentStub = new RecordComponentStub(this.myStub, name, descriptor, signature);
        this.myStub.addRecordComponent(componentStub);
        return new RecordComponentVisitor(this.api){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return new AnnotationBuilderVisitor(componentStub, ClassStubBuilder.this.resolver, visible, descriptor);
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, String descriptor, boolean visible) {
                assert (new TypeReference(typeRef).getSort() == 19) : typeRef;
                return new AnnotationBuilderVisitor.TypeAnnotBuilderImpl(ClassStubBuilder.this.resolver, componentStub, typeRef, typePath, visible, descriptor);
            }
        };
    }

    public void visitOuterClass(String ownerInternalName, @Nullable String methodName, @Nullable String methodDescriptor) {
        this.isAnonOrLocalClass = true;
        this.isInnerNonStaticClass = true;
        ClassStub outer = this.resolver.resolveFromInternalNameCannotFail(ownerInternalName);
        this.myStub.setEnclosingInfo(outer, true, methodName, methodDescriptor);
    }

    public FieldVisitor visitField(int access, String name, String descriptor, @Nullable String signature, @Nullable Object value) {
        final FieldStub field = new FieldStub(this.myStub, name, access, descriptor, signature, value);
        this.myStub.addField(field);
        return new FieldVisitor(589824){

            public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                return new AnnotationBuilderVisitor(field, ClassStubBuilder.this.resolver, visible, descriptor);
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, @Nullable TypePath typePath, String descriptor, boolean visible) {
                assert (new TypeReference(typeRef).getSort() == 19) : typeRef;
                return new AnnotationBuilderVisitor.TypeAnnotBuilderImpl(ClassStubBuilder.this.resolver, field, typeRef, typePath, visible, descriptor);
            }
        };
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        ClassStub permitted = this.resolver.resolveFromInternalNameCannotFail(permittedSubclass);
        this.myStub.addPermittedSubclass(permitted);
    }

    public void visitInnerClass(String innerInternalName, @Nullable String outerName, @Nullable String innerSimpleName, int access) {
        if (this.myInternalName.equals(outerName) && innerSimpleName != null) {
            ClassStub member = this.resolver.resolveFromInternalNameCannotFail(innerInternalName, 0);
            member.setSimpleName(innerSimpleName);
            member.setModifiers(access, false);
            this.myStub.addMemberClass(member);
        } else if (this.myInternalName.equals(innerInternalName)) {
            if (outerName != null) {
                ClassStub outer = this.resolver.resolveFromInternalNameCannotFail(outerName);
                this.myStub.setEnclosingInfo(outer, this.isAnonOrLocalClass, null, null);
            }
            this.myStub.setSimpleName(innerSimpleName == null ? "" : innerSimpleName);
            this.myStub.setModifiers(access, false);
            this.isInnerNonStaticClass = (8 & access) == 0;
        }
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        ExecutableStub execStub;
        if ((access & 0x1040) != 0) {
            return null;
        }
        if ("<clinit>".equals(name)) {
            return null;
        }
        if ("<init>".equals(name)) {
            ExecutableStub.CtorStub ctor = new ExecutableStub.CtorStub(this.myStub, access, descriptor, signature, exceptions, this.isInnerNonStaticClass);
            this.myStub.addCtor(ctor);
            execStub = ctor;
        } else {
            ExecutableStub.MethodStub method = new ExecutableStub.MethodStub(this.myStub, name, access, descriptor, signature, exceptions);
            this.myStub.addMethod(method);
            execStub = method;
        }
        return new MethodInfoVisitor(execStub);
    }
}

