/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.internal;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.rule.internal.CommonPropertyDescriptors;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public abstract class AbstractJavaCounterCheckRule<T extends JavaNode>
extends AbstractJavaRulechainRule {
    private final PropertyDescriptor<Integer> reportLevel = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)CommonPropertyDescriptors.reportLevelProperty().desc("Threshold at or above which a node is reported")).require(NumericConstraints.positive())).defaultValue((Object)this.defaultReportLevel())).build();

    public AbstractJavaCounterCheckRule(Class<T> nodeType) {
        super(nodeType, new Class[0]);
        this.definePropertyDescriptor(this.reportLevel);
    }

    protected abstract int defaultReportLevel();

    protected boolean isIgnored(T node) {
        return false;
    }

    protected abstract int getMetric(T var1);

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        int threshold;
        int metric;
        JavaNode t = node;
        if (!this.isIgnored(t) && (metric = this.getMetric(t)) >= (threshold = ((Integer)this.getProperty(this.reportLevel)).intValue())) {
            this.asCtx(data).addViolation((Node)node, new Object[]{metric, threshold});
        }
        return data;
    }
}

