/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlock;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTEmptyStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class IdenticalConditionalBranchesRule
extends AbstractJavaRulechainRule {
    public IdenticalConditionalBranchesRule() {
        super(ASTIfStatement.class, ASTConditionalExpression.class);
    }

    public Object visit(ASTIfStatement node, Object data) {
        if (node.getElseBranch() != null && this.areEquivalent(this.normalize(node.getThenBranch()), this.normalize(node.getElseBranch()))) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private boolean areEquivalent(JavaNode thenBranch, JavaNode elseBranch) {
        JavaNode normalizedThen = this.normalize(thenBranch);
        JavaNode normalizedElse = this.normalize(elseBranch);
        return normalizedElse == null && normalizedThen == null || normalizedElse != null && normalizedThen != null && JavaAstUtils.tokenEquals(normalizedElse, normalizedThen);
    }

    private JavaNode normalize(JavaNode firstBranch) {
        JavaNode first = firstBranch;
        while (first instanceof ASTBlock && ((ASTBlock)first).size() <= 1) {
            first = (JavaNode)first.getFirstChild();
        }
        return first instanceof ASTEmptyStatement ? null : first;
    }

    public Object visit(ASTConditionalExpression node, Object data) {
        if (node.getElseBranch() != null && JavaAstUtils.tokenEquals(node.getThenBranch(), node.getElseBranch())) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }
}

