/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import java.sql.ResultSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclarator;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.ReturnScopeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;

public class CheckResultSetRule
extends AbstractJavaRule {
    private static final Set<String> METHODS = CollectionUtil.setOf((Object)"next", (Object[])new String[]{"previous", "last", "first"});

    public Object visit(ASTWhileStatement node, Object data) {
        return data;
    }

    public Object visit(ASTReturnStatement node, Object data) {
        return data;
    }

    public Object visit(ASTIfStatement node, Object data) {
        return data;
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (this.isResultSetMethod(node) && !this.isCheckedIndirectly(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return super.visit(node, data);
    }

    private boolean isResultSetMethod(ASTMethodCall node) {
        return METHODS.contains(node.getMethodName()) && TypeTestUtil.isDeclaredInClass(ResultSet.class, node.getMethodType());
    }

    private boolean isCheckedIndirectly(ASTMethodCall node) {
        ASTVariableDeclarator variableDeclarator = (ASTVariableDeclarator)node.ancestors().takeWhile(n -> !(n instanceof ReturnScopeNode)).first(ASTVariableDeclarator.class);
        if (variableDeclarator == null) {
            return false;
        }
        List<ASTAssignableExpr.ASTNamedReferenceExpr> usages = variableDeclarator.getVarId().getLocalUsages();
        return !usages.isEmpty() && usages.get(0).getAccessType() == ASTAssignableExpr.AccessType.READ;
    }
}

