/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.AbstractLiteral;
import net.sourceforge.pmd.lang.java.ast.JavaVisitor;
import net.sourceforge.pmd.lang.rule.xpath.NoAttribute;
import net.sourceforge.pmd.util.StringUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ASTStringLiteral
extends AbstractLiteral
implements ASTLiteral {
    private static final String TEXTBLOCK_DELIMITER = "\"\"\"";
    private boolean isTextBlock;

    ASTStringLiteral(int id) {
        super(id);
    }

    public String getImage() {
        return this.getText().toString();
    }

    @Override
    public Chars getLiteralText() {
        return super.getLiteralText();
    }

    void setTextBlock() {
        this.isTextBlock = true;
    }

    public boolean isTextBlock() {
        return this.isTextBlock;
    }

    public boolean isEmpty() {
        if (this.isTextBlock) {
            return this.getConstValue().isEmpty();
        }
        return this.getLiteralText().length() == 2;
    }

    public int length() {
        return this.getConstValue().length();
    }

    @NoAttribute
    public @NonNull String toPrintableString() {
        return StringUtil.inDoubleQuotes((String)StringUtil.escapeJava((String)this.getConstValue()));
    }

    @Override
    protected <P, R> R acceptVisitor(JavaVisitor<? super P, ? extends R> visitor, P data) {
        return visitor.visit(this, data);
    }

    @Override
    public @NonNull String getConstValue() {
        return (String)super.getConstValue();
    }

    @Override
    @Deprecated
    protected @Nullable String buildConstValue() {
        return (String)super.buildConstValue();
    }

    static @NonNull String determineStringContent(Chars image) {
        Chars woDelims = image.subSequence(1, image.length() - 1);
        StringBuilder sb = new StringBuilder(woDelims.length());
        ASTStringLiteral.interpretEscapeSequences(woDelims, sb, false);
        return sb.toString();
    }

    static String determineTextBlockContent(Chars image) {
        List<Chars> lines = ASTStringLiteral.getContentLines(image);
        StringUtil.trimIndentInPlace(lines);
        StringBuilder sb = new StringBuilder(image.length());
        for (int i = 0; i < lines.size(); ++i) {
            boolean isLastLine;
            Chars line = lines.get(i);
            boolean appendNl = ASTStringLiteral.interpretEscapeSequences(line, sb, !(isLastLine = i == lines.size() - 1));
            if (!appendNl) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    static String determineTextBlockContent(String image) {
        return ASTStringLiteral.determineTextBlockContent(Chars.wrap((CharSequence)image));
    }

    private static @NonNull List<Chars> getContentLines(Chars chars) {
        List<Chars> lines = chars.lineStream().collect(Collectors.toList());
        assert (lines.size() >= 2) : "invalid text block syntax " + chars;
        lines = lines.subList(1, lines.size());
        int lastIndex = lines.size() - 1;
        Chars lastLine = (Chars)lines.get(lastIndex);
        assert (lastLine.endsWith(TEXTBLOCK_DELIMITER));
        lines.set(lastIndex, lastLine.removeSuffix(TEXTBLOCK_DELIMITER));
        return lines;
    }

    private static boolean interpretEscapeSequences(Chars line, StringBuilder out, boolean isEndANewLine) {
        int appended = 0;
        int i = 0;
        block4: while (i < line.length()) {
            char c = line.charAt(i);
            if (c != '\\') {
                ++i;
                continue;
            }
            if (i + 1 == line.length()) {
                if (!isEndANewLine) break;
                line.appendChars(out, appended, i);
                return false;
            }
            char cnext = line.charAt(i + 1);
            switch (cnext) {
                case '\"': 
                case '\'': 
                case '\\': 
                case 'b': 
                case 'f': 
                case 'n': 
                case 'r': 
                case 's': 
                case 't': {
                    line.appendChars(out, appended, i);
                    out.append(ASTStringLiteral.translateBackslashEscape(cnext));
                    appended = i += 2;
                    continue block4;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    line.appendChars(out, appended, i);
                    appended = i = ASTStringLiteral.translateOctalEscape(line, i + 1, out);
                    continue block4;
                }
            }
            ++i;
        }
        if (appended < line.length()) {
            line.appendChars(out, appended, line.length());
        }
        return isEndANewLine;
    }

    private static char translateBackslashEscape(char c) {
        switch (c) {
            case '\\': {
                return '\\';
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'b': {
                return '\b';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 's': {
                return ' ';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
        }
        throw new IllegalArgumentException("Not a valid escape \\" + c);
    }

    private static int translateOctalEscape(Chars src, int firstDigitIndex, StringBuilder sb) {
        int i = firstDigitIndex;
        int result = src.charAt(i) - 48;
        if (src.length() > ++i && ASTStringLiteral.isOctalDigit(src.charAt(i))) {
            result = 8 * result + src.charAt(i) - 48;
            if (src.length() > ++i && ASTStringLiteral.isOctalDigit(src.charAt(i))) {
                result = 8 * result + src.charAt(i) - 48;
                ++i;
            }
        }
        sb.append((char)result);
        return i;
    }

    private static boolean isOctalDigit(char c) {
        return c >= '0' && c <= '7';
    }
}

