/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationslib.org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import se.bjurr.violations.violationslib.org.owasp.encoder.Encoder;

class URIEncoder
extends Encoder {
    static final int CHARS_0_TO_9 = 10;
    static final int CHARS_A_TO_Z = 26;
    static final int LONG_BITS = 64;
    static final int MAX_ENCODED_CHAR_LENGTH = 9;
    static final int PERCENT_ENCODED_LENGTH = 3;
    static final int MAX_UTF8_2_BYTE = 2047;
    static final int UTF8_2_BYTE_FIRST_MSB = 192;
    static final int UTF8_3_BYTE_FIRST_MSB = 224;
    static final int UTF8_4_BYTE_FIRST_MSB = 240;
    static final int UTF8_BYTE_MSB = 128;
    static final int UTF8_SHIFT = 6;
    static final int UTF8_MASK = 63;
    static final char INVALID_REPLACEMENT_CHARACTER = '-';
    static final char[] UHEX = "0123456789ABCDEF".toCharArray();
    static final long UNRESERVED_MASK_LOW = 288054454291267584L;
    static final long UNRESERVED_MASK_HIGH = 5188146764422578174L;
    static final long RESERVED_MASK_LOW = -6052662140534259712L;
    static final long RESERVED_MASK_HIGH = 671088641L;
    private final long _lowMask;
    private final long _highMask;
    private final Mode _mode;

    URIEncoder() {
        this(Mode.FULL_URI);
    }

    URIEncoder(Mode mode) {
        this._mode = mode;
        this._lowMask = mode.lowMask();
        this._highMask = mode.highMask();
    }

    @Override
    protected int maxEncodedLength(int n) {
        return n * 9;
    }

    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            if (ch <= '\u007f') {
                if (ch >= '@' ? (this._highMask & 1L << ch - 64) != 0L : (this._lowMask & 1L << ch) != 0L) continue;
                return i;
            }
            return i;
        }
        return n;
    }

    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i;
        char[] in = input.array();
        char[] out = output.array();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m = output.arrayOffset() + output.limit();
        for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            int b2;
            int b1;
            char ch = in[i];
            if (ch <= '\u007f') {
                if (ch < '@' ? (this._lowMask & 1L << ch) != 0L : (this._highMask & 1L << ch - 64) != 0L) {
                    if (j >= m) {
                        return URIEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue;
                }
                if (j + 3 > m) {
                    return URIEncoder.overflow(input, i, output, j);
                }
                out[j++] = 37;
                out[j++] = UHEX[ch >>> 4];
                out[j++] = UHEX[ch & 0xF];
                continue;
            }
            if (ch <= '\u07ff') {
                if (j + 6 > m) {
                    return URIEncoder.overflow(input, i, output, j);
                }
                b1 = 0xC0 | ch >>> 6;
                out[j++] = 37;
                out[j++] = UHEX[b1 >>> 4];
                out[j++] = UHEX[b1 & 0xF];
                b2 = 0x80 | ch & 0x3F;
                out[j++] = 37;
                out[j++] = UHEX[b2 >>> 4];
                out[j++] = UHEX[b2 & 0xF];
                continue;
            }
            if (ch < '\ud800' || ch > '\udfff') {
                if (j + 9 > m) {
                    return URIEncoder.overflow(input, i, output, j);
                }
                b1 = 0xE0 | ch >>> 12;
                out[j++] = 37;
                out[j++] = UHEX[b1 >>> 4];
                out[j++] = UHEX[b1 & 0xF];
                b2 = 0x80 | ch >>> 6 & 0x3F;
                out[j++] = 37;
                out[j++] = UHEX[b2 >>> 4];
                out[j++] = UHEX[b2 & 0xF];
                int b3 = 0x80 | ch & 0x3F;
                out[j++] = 37;
                out[j++] = UHEX[b3 >>> 4];
                out[j++] = UHEX[b3 & 0xF];
                continue;
            }
            if (ch <= '\udbff') {
                if (i + 1 < n) {
                    if (Character.isLowSurrogate(in[i + 1])) {
                        if (j + 12 > m) {
                            return URIEncoder.overflow(input, i, output, j);
                        }
                        int cp = Character.toCodePoint(ch, in[++i]);
                        int b12 = 0xF0 | cp >>> 18;
                        out[j++] = 37;
                        out[j++] = UHEX[b12 >>> 4];
                        out[j++] = UHEX[b12 & 0xF];
                        int b22 = 0x80 | cp >>> 12 & 0x3F;
                        out[j++] = 37;
                        out[j++] = UHEX[b22 >>> 4];
                        out[j++] = UHEX[b22 & 0xF];
                        int b3 = 0x80 | cp >>> 6 & 0x3F;
                        out[j++] = 37;
                        out[j++] = UHEX[b3 >>> 4];
                        out[j++] = UHEX[b3 & 0xF];
                        int b4 = 0x80 | cp & 0x3F;
                        out[j++] = 37;
                        out[j++] = UHEX[b4 >>> 4];
                        out[j++] = UHEX[b4 & 0xF];
                        continue;
                    }
                    if (j >= m) {
                        return URIEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 45;
                    continue;
                }
                if (!endOfInput) break;
                if (j >= m) {
                    return URIEncoder.overflow(input, i, output, j);
                }
                out[j++] = 45;
                continue;
            }
            if (j >= m) {
                return URIEncoder.overflow(input, i, output, j);
            }
            out[j++] = 45;
        }
        return URIEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "URIEncoder(mode=" + (Object)((Object)this._mode) + ")";
    }

    public static enum Mode {
        COMPONENT(288054454291267584L, 5188146764422578174L),
        FULL_URI(-5764607686242992128L, 5188146765093666815L);

        final long _lowMask;
        final long _highMask;

        private Mode(long low, long high) {
            this._lowMask = low;
            this._highMask = high;
        }

        long lowMask() {
            return this._lowMask;
        }

        long highMask() {
            return this._highMask;
        }
    }
}

