/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.violationslib.org.owasp.encoder;

import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import se.bjurr.violations.violationslib.org.owasp.encoder.ASCIIBits;
import se.bjurr.violations.violationslib.org.owasp.encoder.Encoder;

class CSSEncoder
extends Encoder {
    static final int LONG_BITS = 64;
    static final int HEX_ENCODED_LENGTH = 4;
    static final char INVALID_REPLACEMENT_CHARACTER = '_';
    final long _lowMask;
    final long _highMask;
    final Mode _mode;

    CSSEncoder(Mode mode) {
        this._mode = mode;
        this._lowMask = mode.lowMask();
        this._highMask = mode.highMask();
    }

    @Override
    protected int maxEncodedLength(int n) {
        return 4 * n;
    }

    @Override
    protected int firstEncodedOffset(String input, int off, int len) {
        int n = off + len;
        for (int i = off; i < n; ++i) {
            char ch = input.charAt(i);
            if (ch < '\u0080') {
                if ((ch < '@' ? this._lowMask & 1L << ch : this._highMask & 1L << ch - 64) != 0L) {
                    continue;
                }
            } else if (ch > '\u009f' && ch < '\u2028' || ch > '\u2029') {
                if (ch < '\ud800' || ch > '\udfff') continue;
                if (ch <= '\udbff') {
                    if (i + 1 < n) {
                        if (Character.isLowSurrogate(input.charAt(i + 1))) {
                            ++i;
                            continue;
                        }
                        return i;
                    }
                    return i;
                }
                return i;
            }
            return i;
        }
        return n;
    }

    @Override
    protected CoderResult encodeArrays(CharBuffer input, CharBuffer output, boolean endOfInput) {
        int i;
        char[] in = input.array();
        char[] out = output.array();
        int n = input.arrayOffset() + input.limit();
        int j = output.arrayOffset() + output.position();
        int m = output.arrayOffset() + output.limit();
        for (i = input.arrayOffset() + input.position(); i < n; ++i) {
            int ch = in[i];
            if (ch < 128) {
                if ((ch < 64 ? this._lowMask & 1L << ch : this._highMask & 1L << ch - 64) != 0L) {
                    if (j >= m) {
                        return CSSEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue;
                }
            } else if (ch > 159 && ch < 8232 || ch > 8233) {
                if (ch < 55296 || ch > 57343) {
                    if (j >= m) {
                        return CSSEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = ch;
                    continue;
                }
                if (ch <= 56319) {
                    if (i + 1 < n) {
                        if (Character.isLowSurrogate(in[i + 1])) {
                            if (j + 1 >= m) {
                                return CSSEncoder.overflow(input, i, output, j);
                            }
                            out[j++] = ch;
                            out[j++] = in[++i];
                            continue;
                        }
                        if (j >= m) {
                            return CSSEncoder.overflow(input, i, output, j);
                        }
                        out[j++] = 95;
                        continue;
                    }
                    if (!endOfInput) break;
                    if (j >= m) {
                        return CSSEncoder.overflow(input, i, output, j);
                    }
                    out[j++] = 95;
                    continue;
                }
                if (j >= m) {
                    return CSSEncoder.overflow(input, i, output, j);
                }
                out[j++] = 95;
                continue;
            }
            int k = j + 1;
            int tmp = ch;
            do {
                ++k;
            } while ((tmp >>>= 4) != 0);
            boolean needsSpace = false;
            if (i + 1 < n) {
                char la = in[i + 1];
                if ('0' <= la && la <= '9' || 'a' <= la && la <= 'f' || 'A' <= la && la <= 'F' || la == ' ' || la == '\n' || la == '\r' || la == '\t' || la == '\f') {
                    needsSpace = true;
                    ++k;
                }
            } else if (!endOfInput) break;
            if (k > m) {
                return CSSEncoder.overflow(input, i, output, j);
            }
            out[j] = 92;
            j = k--;
            if (needsSpace) {
                out[k] = 32;
            }
            tmp = ch;
            do {
                out[--k] = HEX[tmp & 0xF];
            } while ((tmp >>>= 4) != 0);
            assert (out[k - 1] == '\\');
        }
        return CSSEncoder.underflow(input, i, output, j);
    }

    public String toString() {
        return "CSSEncoder(mode=" + (Object)((Object)this._mode) + ")";
    }

    static enum Mode {
        STRING(new ASCIIBits().set(32, 126).clear("\"'<&/\\>")),
        URL(new ASCIIBits().set("!#$%").set(42, 91).set(93, 126).clear("/<>"));

        private final long _lowMask;
        private final long _highMask;

        private Mode(ASCIIBits bits) {
            this._lowMask = bits._lowerMask;
            this._highMask = bits._upperMask;
        }

        long lowMask() {
            return this._lowMask;
        }

        long highMask() {
            return this._highMask;
        }
    }
}

