/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.violationslib.com.google.gson.Gson;

public class SonarParser
implements ViolationsParser {
    @Override
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"})
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        SonarReport sonarReport = new Gson().fromJson(string, SonarReport.class);
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (SonarReportIssue issue : sonarReport.getIssues()) {
            if (issue.textRange != null) {
                issue.startLine = issue.textRange.startLine;
                issue.startOffset = issue.textRange.startOffset;
                issue.endLine = issue.textRange.endLine;
                issue.endOffset = issue.textRange.endOffset;
            }
            Integer startColumn = null;
            if (issue.startOffset != null) {
                startColumn = issue.startOffset + 1;
            }
            Integer endColumn = null;
            if (issue.endOffset != null) {
                endColumn = issue.endOffset + 1;
            }
            if (issue.startLine == null || issue.getSeverity() == null) {
                violationsLogger.log(Level.FINE, "Ignoring issue: " + String.valueOf(issue));
                continue;
            }
            if (issue.message == null) {
                issue.message = "N/A";
            }
            violations.add(Violation.violationBuilder().setFile(issue.getFile()).setCategory(issue.getCategory()).setEndLine(issue.endLine).setEndColumn(endColumn).setMessage(issue.message).setParser(Parser.SONAR).setReporter(Parser.SONAR.name()).setRule(issue.rule).setSeverity(issue.getSeverity()).setStartLine(issue.startLine).setColumn(startColumn).setSource(issue.component).build());
        }
        return violations;
    }

    static class SonarReport {
        String version;
        private List<SonarReportIssue> issues;

        SonarReport() {
        }

        public void setIssues(List<SonarReportIssue> issues) {
            this.issues = issues;
        }

        public List<SonarReportIssue> getIssues() {
            if (this.issues == null) {
                return new ArrayList<SonarReportIssue>();
            }
            return this.issues;
        }
    }

    static class SonarIssueTextRange {
        int startLine;
        int startOffset;
        int endLine;
        int endOffset;

        SonarIssueTextRange() {
        }
    }

    static class SonarReportIssue {
        String component;
        int line;
        SonarIssueTextRange textRange;
        Integer startLine;
        Integer startOffset;
        Integer endLine;
        Integer endOffset;
        String message;
        String severity;
        String rule;

        SonarReportIssue() {
        }

        public String getFile() {
            try {
                String[] parts = this.component.split(":");
                return parts[parts.length - 1];
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot understand file " + this.component, t);
            }
        }

        public String getCategory() {
            try {
                return this.rule.split(":")[0];
            }
            catch (Throwable t) {
                throw new RuntimeException("Cannot understand category " + this.rule, t);
            }
        }

        public SEVERITY getSeverity() {
            if (this.severity == null) {
                return null;
            }
            if (this.severity.equalsIgnoreCase("blocker")) {
                return SEVERITY.ERROR;
            }
            if (this.severity.equalsIgnoreCase("critical") || this.severity.equalsIgnoreCase("major")) {
                return SEVERITY.WARN;
            }
            return SEVERITY.INFO;
        }

        public String toString() {
            return "SonarReportIssue [component=" + this.component + ", line=" + this.line + ", startLine=" + this.startLine + ", endLine=" + this.endLine + ", message=" + this.message + ", severity=" + this.severity + ", rule=" + this.rule + "]";
        }
    }
}

