/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class SimianParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            Integer lineCount = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("set")) {
                    lineCount = ViolationParserUtils.getIntegerAttribute(xmlr, "lineCount");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("block")) continue;
                String sourceFile = ViolationParserUtils.getAttribute(xmlr, "sourceFile");
                Integer startLineNumber = ViolationParserUtils.getIntegerAttribute(xmlr, "startLineNumber");
                Integer endLineNumber = ViolationParserUtils.getIntegerAttribute(xmlr, "endLineNumber");
                Violation violation = Violation.violationBuilder().setParser(Parser.SIMIAN).setFile(sourceFile).setMessage("Duplication").setRule("DUPLICATION").setSeverity(this.toSeverity(lineCount)).setStartLine(startLineNumber).setEndLine(endLineNumber).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    private SEVERITY toSeverity(Integer lineCount) {
        if (lineCount < 10) {
            return SEVERITY.INFO;
        }
        if (lineCount < 50) {
            return SEVERITY.WARN;
        }
        return SEVERITY.ERROR;
    }
}

