/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.model.generated.sarif.Artifact;
import se.bjurr.violations.lib.model.generated.sarif.Invocation;
import se.bjurr.violations.lib.model.generated.sarif.Location;
import se.bjurr.violations.lib.model.generated.sarif.Message;
import se.bjurr.violations.lib.model.generated.sarif.Notification;
import se.bjurr.violations.lib.model.generated.sarif.PhysicalLocation;
import se.bjurr.violations.lib.model.generated.sarif.PropertyBag;
import se.bjurr.violations.lib.model.generated.sarif.Region;
import se.bjurr.violations.lib.model.generated.sarif.ReportingConfiguration;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptor;
import se.bjurr.violations.lib.model.generated.sarif.ReportingDescriptorReference;
import se.bjurr.violations.lib.model.generated.sarif.Result;
import se.bjurr.violations.lib.model.generated.sarif.Run;
import se.bjurr.violations.lib.model.generated.sarif.SarifSchema;
import se.bjurr.violations.lib.model.generated.sarif.Suppression;
import se.bjurr.violations.lib.model.generated.sarif.ToolComponent;
import se.bjurr.violations.lib.parsers.SarifParserDeserializer;
import se.bjurr.violations.lib.parsers.SarifParserMessaging;
import se.bjurr.violations.lib.parsers.SarifParserOriginalUri;
import se.bjurr.violations.lib.parsers.SarifParserReportingDescriptorFinder;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;

public class SarifParser
implements ViolationsParser {
    private static Logger LOGGER = Logger.getLogger(SarifParser.class.getSimpleName());
    public static final String SARIF_RESULTS_CORRELATION_GUID = "correlationGuid";
    public static final String SARIF_RESULTS_SUPPRESSED = "suppressed";

    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        SarifSchema report = SarifParserDeserializer.fromJson(reportContent);
        TreeSet<Violation> violations = new TreeSet<Violation>();
        if (report.getRuns() == null) {
            return violations;
        }
        for (Run run : report.getRuns()) {
            Map<String, String> originalUriBaseIdsMap = SarifParserOriginalUri.getOriginalUriBaseIdsMap(run.getOriginalUriBaseIds());
            violations.addAll(this.parseNotifications(run, originalUriBaseIdsMap));
            violations.addAll(this.parseResults(run, originalUriBaseIdsMap));
        }
        return violations;
    }

    private Set<Violation> parseResults(Run run, Map<String, String> originalUriBaseIdsMap) {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (Result result : run.getResults()) {
            String ruleId = SarifParserReportingDescriptorFinder.findRuleId(result, result.getRule());
            Message message = result.getMessage();
            if (message == null) continue;
            Object level = result.getLevel();
            HashMap<String, String> specifics = new HashMap<String, String>();
            String correlationGuid = result.getCorrelationGuid();
            if (!Utils.isNullOrEmpty(correlationGuid)) {
                specifics.put(SARIF_RESULTS_CORRELATION_GUID, correlationGuid);
            }
            specifics.put(SARIF_RESULTS_SUPPRESSED, this.isSuppressed(result) ? "true" : "false");
            ReportingDescriptor reportingDescriptor = SarifParserReportingDescriptorFinder.findReportingDescriptor(run, result, SarifParserReportingDescriptorFinder.DescriptorElementOf.RULES).orElse(null);
            String category = this.getCategory(reportingDescriptor);
            String reporter = this.getReporter(run, result.getRule());
            if (ruleId == null && reportingDescriptor != null) {
                ruleId = reportingDescriptor.getId();
            }
            if (this.notEmptyOrNull(result.getLocations())) {
                for (Location location : result.getLocations()) {
                    ParsedPhysicalLocation parsedPhysicalLocation = this.parsePhysicalLocation(location.getPhysicalLocation(), run.getArtifacts(), originalUriBaseIdsMap);
                    String fullMessage = SarifParserMessaging.getMessageText(message, parsedPhysicalLocation, reportingDescriptor);
                    violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile(parsedPhysicalLocation.filename).setStartLine(parsedPhysicalLocation.startLine).setRule(ruleId).setMessage(fullMessage).setSeverity(this.toSeverity(level, reportingDescriptor)).setReporter(reporter).setCategory(category).setSpecifics(specifics).build());
                }
                continue;
            }
            String fullMessage = SarifParserMessaging.getMessageText(message, null, reportingDescriptor);
            violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile("-").setStartLine(Violation.NO_LINE).setRule(ruleId).setMessage(fullMessage).setSeverity(this.toSeverity(level, reportingDescriptor)).setReporter(reporter).setCategory(category).setSpecifics(specifics).build());
        }
        return violations;
    }

    private Set<Violation> parseNotifications(Run run, Map<String, String> originalUriBaseIdsMap) {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        for (Invocation invocation : run.getInvocations()) {
            for (Notification notification : invocation.getToolConfigurationNotifications()) {
                ReportingDescriptorReference ref = notification.getAssociatedRule();
                String ruleId = null;
                ReportingDescriptor reportingDescriptor = SarifParserReportingDescriptorFinder.findReportingDescriptor(run, SarifParserReportingDescriptorFinder.DescriptorElementOf.NOTIFICATIONS, ref, ruleId).orElse(null);
                String reporter = this.getReporter(run, ref);
                String reportingDescriptorName = this.getName(reportingDescriptor);
                SEVERITY severity = this.toSeverity(notification.getLevel(), reportingDescriptor);
                if (this.notEmptyOrNull(notification.getLocations())) {
                    for (Location location : notification.getLocations()) {
                        ParsedPhysicalLocation parsedPhysicalLocation = this.parsePhysicalLocation(location.getPhysicalLocation(), run.getArtifacts(), originalUriBaseIdsMap);
                        String fullMessage = SarifParserMessaging.getMessageText(notification.getMessage(), parsedPhysicalLocation, reportingDescriptor);
                        violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile(parsedPhysicalLocation.filename).setStartLine(parsedPhysicalLocation.startLine).setRule(reportingDescriptorName).setMessage(fullMessage).setSeverity(severity).setReporter(reporter).build());
                    }
                    continue;
                }
                String message = SarifParserMessaging.getMessageText(notification.getMessage(), reportingDescriptor);
                if (message.isEmpty()) continue;
                violations.add(Violation.violationBuilder().setParser(Parser.SARIF).setFile("-").setStartLine(Violation.NO_LINE).setRule(reportingDescriptorName).setMessage(message).setSeverity(severity).setReporter(reporter).build());
            }
        }
        return violations;
    }

    private ParsedPhysicalLocation parsePhysicalLocation(PhysicalLocation physicalLocation, Set<Artifact> artifacts, Map<String, String> originalUriBaseIdsMap) {
        Integer artifactLocationIndex;
        ParsedPhysicalLocation parsed = new ParsedPhysicalLocation();
        Region region = physicalLocation.getRegion();
        if (region != null) {
            parsed.startLine = Optional.ofNullable(region.getStartLine()).orElse(Violation.NO_LINE);
            parsed.regionMessage = SarifParserMessaging.findMessageText(region.getMessage()).orElse("");
        } else {
            parsed.startLine = Violation.NO_LINE;
            parsed.regionMessage = "";
        }
        parsed.filename = "";
        String uriBaseId = physicalLocation.getArtifactLocation().getUriBaseId();
        if (uriBaseId != null) {
            String originalUriBaseId = originalUriBaseIdsMap.get(uriBaseId);
            if (originalUriBaseId == null) {
                LOGGER.warning("Did not find '" + uriBaseId + "' in originalUriBaseIds " + String.valueOf(originalUriBaseIdsMap.keySet()));
            }
            if (originalUriBaseId != null && !originalUriBaseId.isEmpty()) {
                parsed.filename = parsed.filename + originalUriBaseId;
            }
        }
        parsed.filename = (artifactLocationIndex = physicalLocation.getArtifactLocation().getIndex()) != null && artifactLocationIndex != -1 ? parsed.filename + new ArrayList<Artifact>(artifacts).get(artifactLocationIndex).getLocation().getUri() : parsed.filename + physicalLocation.getArtifactLocation().getUri();
        return parsed;
    }

    private boolean isSuppressed(Result result) {
        List supressions = result.getSuppressions().stream().filter(it -> it.getState() != Suppression.State.UNDER_REVIEW && it.getState() != Suppression.State.REJECTED).collect(Collectors.toList());
        return !supressions.isEmpty();
    }

    private String getReporter(Run run, ReportingDescriptorReference ref) {
        ToolComponent tool = SarifParserReportingDescriptorFinder.findToolComponent(run, ref);
        if (tool != null && tool.getName() != null && !tool.getName().trim().isEmpty()) {
            return tool.getName();
        }
        return "Sarif";
    }

    private String getName(ReportingDescriptor reportingDescriptor) {
        if (reportingDescriptor != null) {
            return reportingDescriptor.getName();
        }
        return null;
    }

    private String getCategory(ReportingDescriptor reportingDescriptor) {
        PropertyBag properties;
        if (reportingDescriptor != null && (properties = reportingDescriptor.getProperties()) != null && properties.getCategory() != null) {
            return properties.getCategory();
        }
        return null;
    }

    private boolean notEmptyOrNull(Collection<Location> locations) {
        return locations != null && !locations.isEmpty();
    }

    private SEVERITY toSeverity(Notification.Level level, ReportingDescriptor reportingDescriptor) {
        if (level == null) {
            return this.toSeverity(reportingDescriptor).orElse(SEVERITY.INFO);
        }
        if (level == Notification.Level.ERROR) {
            return SEVERITY.ERROR;
        }
        if (level == Notification.Level.WARNING) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private SEVERITY toSeverity(Object level, ReportingDescriptor reportingDescriptor) {
        if (level == null) {
            return this.toSeverity(reportingDescriptor).orElse(SEVERITY.INFO);
        }
        if (level.equals("error")) {
            return SEVERITY.ERROR;
        }
        if (level.equals("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }

    private Optional<SEVERITY> toSeverity(ReportingDescriptor reportingDescriptor) {
        if (reportingDescriptor != null && reportingDescriptor.getDefaultConfiguration() != null && reportingDescriptor.getDefaultConfiguration().getLevel() != null) {
            ReportingConfiguration.Level level = reportingDescriptor.getDefaultConfiguration().getLevel();
            if (level == ReportingConfiguration.Level.ERROR) {
                return Optional.of(SEVERITY.ERROR);
            }
            if (level == ReportingConfiguration.Level.WARNING) {
                return Optional.of(SEVERITY.WARN);
            }
        }
        return Optional.empty();
    }

    static class ParsedPhysicalLocation {
        public String regionMessage = null;
        public String filename = "-";
        public Integer startLine = Violation.NO_LINE;
    }
}

