/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class JSLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String content, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            String filename = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("file")) {
                    filename = ViolationParserUtils.getAttribute(xmlr, "name");
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("issue")) continue;
                Integer line = ViolationParserUtils.getIntegerAttribute(xmlr, "line");
                Integer charAttrib = ViolationParserUtils.getIntegerAttribute(xmlr, "char");
                String severity = ViolationParserUtils.getAttribute(xmlr, "severity");
                String reason = ViolationParserUtils.getAttribute(xmlr, "reason").trim();
                String evidence = ViolationParserUtils.getAttribute(xmlr, "evidence").trim();
                String message = reason + ": " + evidence;
                Violation violation = Violation.violationBuilder().setParser(Parser.JSLINT).setStartLine(line).setColumn(charAttrib).setFile(filename).setSeverity(this.toSeverity(severity)).setMessage(message).build();
                violations.add(violation);
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("E")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("W")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

