/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class GHSParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<List<String>> partsPerLine = ViolationParserUtils.getLines(reportContent, "^([^:]+?),\\D*(\\d+)?:\\s*(\\D*\\d+\\D*):\\s*(.*)$");
        for (List<String> parts : partsPerLine) {
            String fileName = parts.get(1);
            Integer lineNumber = 0;
            if (!parts.get(2).isEmpty()) {
                lineNumber = Integer.parseInt(parts.get(2));
            }
            String severity = parts.get(3);
            String message = parts.get(4);
            violations.add(Violation.violationBuilder().setParser(Parser.GHS).setStartLine(lineNumber).setFile(fileName).setSeverity(this.toSeverity(severity)).setMessage(message).build());
        }
        return violations;
    }

    public SEVERITY toSeverity(String severity) {
        if (Utils.isNullOrEmpty(severity)) {
            return SEVERITY.INFO;
        }
        String lowerCase = severity.toLowerCase(Locale.ENGLISH);
        if (lowerCase.contains("low")) {
            return SEVERITY.INFO;
        }
        if (lowerCase.contains("error") || lowerCase.contains("c") || lowerCase.contains("high")) {
            return SEVERITY.ERROR;
        }
        if (lowerCase.contains("warning") || lowerCase.contains("w") || lowerCase.contains("medium")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

