/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CppLintParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String string, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        List<String> lines = ViolationParserUtils.getLines(string);
        for (String line : lines) {
            List<String> parts = ViolationParserUtils.getParts(line, "\\[([^\\]]*)\\]$", "\\[([^\\]]*)\\]$", "^([^:]*):", "^([^:]*):", "(.*)");
            if (parts.isEmpty()) continue;
            try {
                Integer severity = Integer.parseInt(parts.get(0));
                String rule = parts.get(1);
                String filename = parts.get(2);
                int lineNumber = parts.get(3).equalsIgnoreCase("None") ? 0 : Integer.parseInt(parts.get(3));
                String message = parts.get(4);
                violations.add(Violation.violationBuilder().setParser(Parser.CPPLINT).setStartLine(lineNumber).setFile(filename).setRule(rule).setSeverity(this.toSeverity(severity)).setMessage(message).build());
            }
            catch (IndexOutOfBoundsException | NullPointerException e) {
                violationsLogger.log(Level.SEVERE, "Was unable to parse: \"" + line + "\" found parts: " + String.valueOf(parts) + " content:\n\n" + string, e);
            }
        }
        return violations;
    }

    public SEVERITY toSeverity(Integer severity) {
        if (severity >= 5) {
            return SEVERITY.ERROR;
        }
        if (severity >= 3) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

