/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.parsers;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamReader;
import se.bjurr.violations.lib.ViolationsLogger;
import se.bjurr.violations.lib.model.SEVERITY;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.parsers.ViolationsParser;
import se.bjurr.violations.lib.reports.Parser;
import se.bjurr.violations.lib.util.Utils;
import se.bjurr.violations.lib.util.ViolationParserUtils;

public class CPPCheckParser
implements ViolationsParser {
    @Override
    public Set<Violation> parseReportOutput(String reportContent, ViolationsLogger violationsLogger) throws Exception {
        TreeSet<Violation> violations = new TreeSet<Violation>();
        try (ByteArrayInputStream input = new ByteArrayInputStream(reportContent.getBytes(StandardCharsets.UTF_8));){
            XMLStreamReader xmlr = ViolationParserUtils.createXmlReader(input);
            SEVERITY severity = null;
            String msg = null;
            Optional<String> verbose = null;
            String id = null;
            int errorIndex = -1;
            int order = 0;
            boolean violationAddedFromError = false;
            String message = null;
            while (xmlr.hasNext()) {
                int eventType = xmlr.next();
                if (eventType == 2 && xmlr.getLocalName().equalsIgnoreCase("error") && !violationAddedFromError) {
                    Violation violation = Violation.violationBuilder().setParser(Parser.CPPCHECK).setStartLine(0).setFile("-").setSeverity(severity).setMessage(message).setRule(id).setGroup(Integer.toString(errorIndex)).build();
                    violations.add(violation);
                }
                if (eventType != 1) continue;
                if (xmlr.getLocalName().equalsIgnoreCase("error")) {
                    violationAddedFromError = false;
                    ++errorIndex;
                    String severityStr = ViolationParserUtils.getAttribute(xmlr, "severity");
                    severity = this.toSeverity(severityStr);
                    msg = ViolationParserUtils.getAttribute(xmlr, "msg");
                    verbose = ViolationParserUtils.findAttribute(xmlr, "verbose");
                    id = ViolationParserUtils.getAttribute(xmlr, "id");
                    Optional<String> resultFile = ViolationParserUtils.findAttribute(xmlr, "file");
                    Optional<Integer> resultLine = ViolationParserUtils.findIntegerAttribute(xmlr, "line");
                    Optional<Integer> resultColumn = ViolationParserUtils.findIntegerAttribute(xmlr, "column");
                    Optional<String> resultInfo = ViolationParserUtils.findAttribute(xmlr, "info");
                    message = this.constructMessage(msg, verbose, resultInfo);
                    if (!resultFile.isPresent() || !resultLine.isPresent()) continue;
                    Violation violation = Violation.violationBuilder().setParser(Parser.CPPCHECK).setStartLine(resultLine.get()).setColumn(resultColumn.orElse(0)).setFile(resultFile.get()).setSeverity(severity).setMessage(message).setRule(id).setGroup(Integer.toString(errorIndex)).build();
                    violations.add(violation);
                    violationAddedFromError = true;
                    continue;
                }
                if (!xmlr.getLocalName().equalsIgnoreCase("location")) continue;
                Integer line = ViolationParserUtils.getIntegerAttribute(xmlr, "line");
                Optional<Integer> column = ViolationParserUtils.findIntegerAttribute(xmlr, "column");
                Optional<String> info = ViolationParserUtils.findAttribute(xmlr, "info");
                message = this.constructMessage(msg, verbose, info);
                String file = ViolationParserUtils.findAttribute(xmlr, "file").orElse("");
                file = Utils.firstNonNull(Utils.emptyToNull(file), "-");
                Violation v = Violation.violationBuilder().setParser(Parser.CPPCHECK).setMessage(message).setStartLine(line).setColumn(column.orElse(null)).setFile(file).setSeverity(severity).setRule(id).setGroup(Integer.toString(errorIndex)).setSpecific("order", order++).build();
                violations.add(v);
                violationAddedFromError = true;
            }
        }
        return violations;
    }

    private String constructMessage(String msg, Optional<String> verbose, Optional<String> info) {
        Object message = verbose.orElse("").startsWith(msg) ? verbose.get() : msg + ". " + verbose.orElse("");
        if (info.isPresent() && !((String)message).contains(info.get())) {
            message = (String)message + ". " + info.get();
        }
        return message;
    }

    public SEVERITY toSeverity(String severity) {
        if (severity.equalsIgnoreCase("error")) {
            return SEVERITY.ERROR;
        }
        if (severity.equalsIgnoreCase("warning")) {
            return SEVERITY.WARN;
        }
        return SEVERITY.INFO;
    }
}

