/*
 * Decompiled with CFR 0.152.
 */
package se.bjurr.violations.lib.model.codeclimate;

import se.bjurr.violations.lib.model.codeclimate.CodeClimateLines;
import se.bjurr.violations.lib.model.codeclimate.CodeClimatePositions;
import se.bjurr.violations.lib.util.Utils;

public class CodeClimateLocation {
    private final String path;
    private final CodeClimateLines lines;
    private final CodeClimatePositions positions;

    public CodeClimateLocation(String path, CodeClimateLines lines, CodeClimatePositions positions) {
        this.path = Utils.checkNotNull(Utils.emptyToNull(path), "path");
        this.lines = Utils.checkNotNull(lines, "lines");
        this.positions = positions;
    }

    public CodeClimatePositions getPositions() {
        return this.positions;
    }

    public CodeClimateLines getLines() {
        return this.lines;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lines == null ? 0 : this.lines.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.positions == null ? 0 : this.positions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeClimateLocation other = (CodeClimateLocation)obj;
        if (this.lines == null ? other.lines != null : !this.lines.equals(other.lines)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.positions == null ? other.positions != null : !this.positions.equals(other.positions));
    }

    public String toString() {
        return "CodeClimateLocation [path=" + this.path + ", lines=" + String.valueOf(this.lines) + ", positions=" + String.valueOf(this.positions) + "]";
    }
}

