/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.database;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.util.database.DBType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBURI {
    private static final Logger LOG = LoggerFactory.getLogger(DBURI.class);
    private URI uri;
    private DBType dbType;
    private String url;
    private String subprotocol;
    private String subnamePrefix;
    private Map<String, String> parameters;
    private List<String> schemasList;
    private List<String> sourceCodeTypesList;
    private List<String> sourceCodeNamesList;
    private List<String> languagesList;
    private String driverClass;
    private String characterSet;
    private String sourceCodeTypes;
    private String sourceCodeNames;
    private String languages;
    private int sourceCodeType;

    public DBURI(String string) throws URISyntaxException, IOException {
        this(new URI(string));
    }

    public DBURI(URI uri) throws URISyntaxException, IOException {
        this.uri = uri;
        String[] splitURI = uri.toString().split("\\?");
        this.url = splitURI.length > 1 ? splitURI[0] : uri.toString();
        LOG.debug("Extracted URL={}", (Object)this.url);
        this.setFields();
        if (splitURI.length > 1) {
            String chimeraString = "http://local?" + uri.toString().substring(this.url.length() + 1);
            LOG.trace("chimeraString={}", (Object)chimeraString);
            URI chimeraURI = new URI(chimeraString);
            DBURI.dump("chimeraURI", chimeraURI);
            this.parameters = this.getParameterMap(chimeraURI);
            LOG.trace("parameterMap=={}", this.parameters);
            this.characterSet = this.parameters.get("characterset");
            this.sourceCodeTypes = this.parameters.get("sourcecodetypes");
            this.sourceCodeNames = this.parameters.get("sourcecodenames");
            this.languages = this.parameters.get("languages");
            if (null != this.sourceCodeNames) {
                this.sourceCodeNamesList = Arrays.asList(this.sourceCodeNames.split(","));
            }
            if (null != this.languages) {
                this.languagesList = Arrays.asList(this.languages.split(","));
            }
            if (null != this.parameters.get("schemas")) {
                this.schemasList = Arrays.asList(this.parameters.get("schemas").split(","));
            }
            if (null != this.sourceCodeTypes) {
                this.sourceCodeTypesList = Arrays.asList(this.sourceCodeTypes.split(","));
            }
        }
    }

    private Map<String, String> getParameterMap(URI dburi) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        String query = dburi.getRawQuery();
        LOG.trace("dburi,getQuery()={}", (Object)query);
        if (null != query && !"".equals(query)) {
            String[] params;
            for (String param : params = query.split("&")) {
                String[] splits = param.split("=");
                String name = splits[0];
                String value = null;
                if (splits.length > 1) {
                    value = splits[1];
                }
                map.put(name, null == value ? value : URLDecoder.decode(value, "UTF-8"));
            }
        }
        return map;
    }

    static void dump(String description, URI dburi) {
        LOG.debug("dump ({})\n: isOpaque={}, isAbsolute={} Scheme={},\n SchemeSpecificPart={},\n Host={},\n Port={},\n Path={},\n Fragment={},\n Query={}", new Object[]{description, dburi.isOpaque(), dburi.isAbsolute(), dburi.getScheme(), dburi.getSchemeSpecificPart(), dburi.getHost(), dburi.getPort(), dburi.getPath(), dburi.getFragment(), dburi.getQuery()});
        String query = dburi.getQuery();
        if (null != query && !"".equals(query)) {
            String[] params = query.split("&");
            HashMap<String, String> map = new HashMap<String, String>();
            for (String param : params) {
                String[] splits = param.split("=");
                String name = splits[0];
                String value = null;
                if (splits.length > 1) {
                    value = splits[1];
                }
                map.put(name, value);
                LOG.debug("name={},value={}", (Object)name, (Object)value);
            }
        }
    }

    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public List<String> getSchemasList() {
        return this.schemasList;
    }

    public void setSchemasList(List<String> schemasList) {
        this.schemasList = schemasList;
    }

    public List<String> getSourceCodeTypesList() {
        return this.sourceCodeTypesList;
    }

    public void setSourceCodeTypesList(List<String> sourceCodeTypesList) {
        this.sourceCodeTypesList = sourceCodeTypesList;
    }

    public List<String> getSourceCodeNamesList() {
        return this.sourceCodeNamesList;
    }

    public void setSourceCodeNamesList(List<String> sourceCodeNamesList) {
        this.sourceCodeNamesList = sourceCodeNamesList;
    }

    public List<String> getLanguagesList() {
        return this.languagesList;
    }

    public void setLanguagesList(List<String> languagesList) {
        this.languagesList = languagesList;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public int getSourceCodeType() {
        return this.sourceCodeType;
    }

    public void setSourceCodeType(int sourceCodeType) {
        this.sourceCodeType = sourceCodeType;
    }

    public String getSubprotocol() {
        return this.subprotocol;
    }

    public void setSubprotocol(String subprotocol) {
        this.subprotocol = subprotocol;
    }

    public String getSubnamePrefix() {
        return this.subnamePrefix;
    }

    public void setSubnamePrefix(String subnamePrefix) {
        this.subnamePrefix = subnamePrefix;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String jdbcURL) {
        this.url = jdbcURL;
    }

    private void setFields() throws URISyntaxException, IOException {
        if (this.url.startsWith("jdbc:")) {
            String returnType;
            String[] uriParts;
            URI jdbcURI = new URI(this.getURL().substring(5));
            LOG.debug("setFields - substr(jdbcURL,5):{}", (Object)this.getURL().substring(5));
            DBURI.dump("substr(jdbcURL,5)", jdbcURI);
            for (String part : uriParts = this.url.split(":")) {
                LOG.trace("JDBCpart={}", (Object)part);
            }
            if (3 == uriParts.length) {
                this.subprotocol = uriParts[1];
            } else if (4 <= uriParts.length) {
                this.subprotocol = uriParts[1];
                this.subnamePrefix = uriParts[2];
            } else {
                throw new URISyntaxException(this.getURL(), "Could not understand JDBC URL", 1);
            }
            LOG.debug("subprotocol={}'' subnamePrefix={}", (Object)this.subprotocol, (Object)this.subnamePrefix);
            this.dbType = new DBType(this.subprotocol, this.subnamePrefix);
            LOG.debug("DBType properties found at {} with {} properties.", (Object)this.dbType.getPropertiesSource(), (Object)this.dbType.getProperties().size());
            LOG.trace("DBType properties are:- {}", (Object)this.dbType.getProperties());
            if (null != this.dbType.getDriverClass()) {
                this.driverClass = this.dbType.getDriverClass();
            }
            if (null != this.dbType.getCharacterSet()) {
                this.characterSet = this.dbType.getCharacterSet();
            }
            if (null != this.dbType.getLanguages()) {
                this.languages = this.dbType.getLanguages();
            }
            if (null != this.dbType.getSourceCodeTypes()) {
                this.sourceCodeTypes = this.dbType.getSourceCodeTypes();
            }
            LOG.debug("DBType other properties follow  ...");
            if (null != this.dbType.getProperties().getProperty("schemas")) {
                this.schemasList = Arrays.asList(this.dbType.getProperties().getProperty("schemas").split(","));
            }
            if (null != this.dbType.getProperties().getProperty("sourcecodenames")) {
                this.sourceCodeNames = this.dbType.getProperties().getProperty("sourcecodenames");
            }
            if (null != (returnType = this.dbType.getProperties().getProperty("returnType"))) {
                this.sourceCodeType = Integer.parseInt(returnType);
            }
            LOG.debug("DBType populating lists ");
            if (null != this.sourceCodeNames) {
                this.sourceCodeNamesList = Arrays.asList(this.sourceCodeNames.split(","));
            }
            if (null != this.languages) {
                this.languagesList = Arrays.asList(this.languages.split(","));
            }
            if (null != this.sourceCodeTypes) {
                this.sourceCodeTypesList = Arrays.asList(this.sourceCodeTypes.split(","));
            }
            LOG.debug("DBType lists generated");
        }
    }

    public String toString() {
        return this.uri.toASCIIString();
    }
}

