/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.ast.AstInfo;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import net.sourceforge.pmd.lang.rule.xpath.internal.DeprecatedAttrLogger;
import net.sourceforge.pmd.lang.rule.xpath.internal.SaxonXPathRuleQuery;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.DataMap;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ViolationSuppressor {
    public static final ViolationSuppressor REGEX_SUPPRESSOR = new ViolationSuppressor(){

        @Override
        public String getId() {
            return "Regex";
        }

        @Override
        public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            Optional<Pattern> regex = rv.getRule().getProperty(Rule.VIOLATION_SUPPRESS_REGEX_DESCRIPTOR);
            if (regex.isPresent() && rv.getDescription() != null && regex.get().matcher(rv.getDescription()).matches()) {
                return new Report.SuppressedViolation(rv, this, regex.get().pattern());
            }
            return null;
        }
    };
    public static final ViolationSuppressor XPATH_SUPPRESSOR = new ViolationSuppressor(){

        @Override
        public String getId() {
            return "XPath";
        }

        @Override
        public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            Rule rule = rv.getRule();
            Optional<String> xpath = rule.getProperty(Rule.VIOLATION_SUPPRESS_XPATH_DESCRIPTOR);
            if (!xpath.isPresent()) {
                return null;
            }
            SaxonXPathRuleQuery rq = new SaxonXPathRuleQuery(xpath.get(), XPathVersion.DEFAULT, rule.getPropertiesByPropertyDescriptor(), node.getAstInfo().getLanguageProcessor().services().getXPathHandler(), DeprecatedAttrLogger.createForSuppression(rv.getRule()));
            if (!rq.evaluate(node).isEmpty()) {
                return new Report.SuppressedViolation(rv, this, xpath.get());
            }
            return null;
        }
    };
    public static final ViolationSuppressor NOPMD_COMMENT_SUPPRESSOR = new ViolationSuppressor(){
        private final DataMap.SimpleDataKey<Set<SuppressionCommentWrapper>> usedSuppressionComments = DataMap.simpleDataKey("pmd.core.comment.suppressor");

        @Override
        public String getId() {
            return "//NOPMD";
        }

        @Override
        public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
            AstInfo<? extends RootNode> astInfo = node.getAstInfo();
            SuppressionCommentWrapper wrapper = astInfo.getSuppressionComment(rv.getBeginLine());
            if (wrapper != null) {
                astInfo.getUserMap().computeIfAbsent(this.usedSuppressionComments, HashSet::new).add(wrapper);
                return new Report.SuppressedViolation(rv, this, wrapper.getUserMessage());
            }
            return null;
        }

        @Override
        public Set<UnusedSuppressorNode> getUnusedSuppressors(RootNode tree) {
            Set usedSuppressors = tree.getAstInfo().getUserMap().getOrDefault(this.usedSuppressionComments, Collections.emptySet());
            final HashSet<SuppressionCommentWrapper> allSuppressors = new HashSet<SuppressionCommentWrapper>(tree.getAstInfo().getAllSuppressionComments());
            allSuppressors.removeAll(usedSuppressors);
            return new AbstractSet<UnusedSuppressorNode>(){

                @Override
                public @NonNull Iterator<UnusedSuppressorNode> iterator() {
                    return IteratorUtil.map(allSuppressors.iterator(), comment -> new UnusedSuppressorNode(){
                        final /* synthetic */ SuppressionCommentWrapper val$comment;
                        {
                            this.val$comment = suppressionCommentWrapper;
                        }

                        @Override
                        public Reportable getLocation() {
                            return this.val$comment.getLocation();
                        }

                        @Override
                        public String unusedReason() {
                            return "Unnecessary PMD suppression comment";
                        }
                    });
                }

                @Override
                public int size() {
                    return allSuppressors.size();
                }
            };
        }
    };

    public String getId();

    public @Nullable Report.SuppressedViolation suppressOrNull(RuleViolation var1, @NonNull Node var2);

    default public Set<UnusedSuppressorNode> getUnusedSuppressors(RootNode tree) {
        return Collections.emptySet();
    }

    public static @Nullable Report.SuppressedViolation suppressOrNull(List<ViolationSuppressor> suppressorList, RuleViolation rv, Node node) {
        for (ViolationSuppressor suppressor : suppressorList) {
            Report.SuppressedViolation suppressed = suppressor.suppressOrNull(rv, node);
            if (suppressed == null) continue;
            return suppressed;
        }
        return null;
    }

    @Experimental
    public static interface SuppressionCommentWrapper {
        public String getUserMessage();

        public Reportable getLocation();
    }

    public static interface UnusedSuppressorNode {
        public Reportable getLocation();

        public String unusedReason();
    }
}

