/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.reporting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.RootNode;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.Reportable;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.reporting.ViolationSuppressor;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.DataMap;
import net.sourceforge.pmd.util.OptionalBool;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractAnnotationSuppressor<A extends Node>
implements ViolationSuppressor {
    private final Class<A> annotationNodeType;
    private static final DataMap.SimpleDataKey<Boolean> KEY_SUPPRESSED_ANY_VIOLATION = DataMap.simpleDataKey("pmd.core.suppressed.any");

    protected AbstractAnnotationSuppressor(Class<A> annotationClass) {
        this.annotationNodeType = annotationClass;
    }

    @Override
    public String getId() {
        return "@SuppressWarnings";
    }

    @Override
    public Report.SuppressedViolation suppressOrNull(RuleViolation rv, @NonNull Node node) {
        if (this.contextSuppresses(node, rv.getRule())) {
            return new Report.SuppressedViolation(rv, this, null);
        }
        return null;
    }

    @Override
    public Set<ViolationSuppressor.UnusedSuppressorNode> getUnusedSuppressors(RootNode tree) {
        return tree.descendants(this.annotationNodeType).crossFindBoundaries().toStream().map(this::getUnusedSuppressorNodes).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean contextSuppresses(Node node, Rule rule) {
        if (this.suppresses(node, rule)) {
            return true;
        }
        if (node instanceof RootNode) {
            for (int i = 0; i < node.getNumChildren(); ++i) {
                if (!this.suppresses(node.getChild(i), rule)) continue;
                return true;
            }
        }
        for (Node parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!this.suppresses(parent, rule)) continue;
            return true;
        }
        return false;
    }

    private boolean suppresses(Node node, Rule rule) {
        return this.getAnnotations(node).any(it -> this.annotationSuppresses(it, rule));
    }

    private boolean annotationSuppresses(A annotation, Rule rule) {
        ArrayList<AnnotationPartWrapper> applicableParts = new ArrayList<AnnotationPartWrapper>();
        this.walkAnnotation(annotation, (parm, stringValue) -> {
            if (this.annotationParamSuppresses(stringValue, rule)) {
                applicableParts.add(new AnnotationPartWrapper(parm, stringValue));
            }
            return false;
        });
        AnnotationPartWrapper mostSpecific = AbstractAnnotationSuppressor.getMostSpecific(applicableParts);
        if (mostSpecific != null) {
            mostSpecific.node.getUserMap().compute(KEY_SUPPRESSED_ANY_VIOLATION, a -> Boolean.TRUE);
            return true;
        }
        return false;
    }

    private static @Nullable AnnotationPartWrapper getMostSpecific(List<AnnotationPartWrapper> parts) {
        if (parts.isEmpty()) {
            return null;
        }
        if (parts.size() == 1) {
            return parts.get(0);
        }
        parts.sort(AbstractAnnotationSuppressor::compareSpecificity);
        if (parts.stream().allMatch(p -> AbstractAnnotationSuppressor.isPmdSuppressor(((AnnotationPartWrapper)p).stringValue))) {
            return parts.get(parts.size() - 1);
        }
        return parts.get(0);
    }

    protected abstract boolean walkAnnotation(A var1, AnnotationWalkCallbacks var2);

    protected abstract NodeStream<A> getAnnotations(Node var1);

    protected String getAnnotationName(A annotation) {
        return "@SuppressWarnings annotation";
    }

    protected boolean annotationParamSuppresses(String stringVal, Rule rule) {
        return "PMD".equals(stringVal) || ("PMD." + rule.getName()).equals(stringVal) || "all".equals(stringVal);
    }

    protected OptionalBool isSuppressingNonPmdWarnings(String stringVal, A annotation) {
        if (AbstractAnnotationSuppressor.isPmdSuppressor(stringVal)) {
            return OptionalBool.NO;
        }
        return OptionalBool.UNKNOWN;
    }

    private Set<ViolationSuppressor.UnusedSuppressorNode> getUnusedSuppressorNodes(A annotation) {
        HashSet<ViolationSuppressor.UnusedSuppressorNode> unusedParts = new HashSet<ViolationSuppressor.UnusedSuppressorNode>();
        MutableBoolean entireAnnotationIsUnused = new MutableBoolean(true);
        MutableBoolean anySuppressor = new MutableBoolean(false);
        this.walkAnnotation(annotation, (annotationParam, stringValue) -> {
            anySuppressor.setTrue();
            boolean suppressedAny = annotationParam.getUserMap().getOrDefault(KEY_SUPPRESSED_ANY_VIOLATION, Boolean.FALSE);
            if (suppressedAny) {
                entireAnnotationIsUnused.setFalse();
            } else if (this.isSuppressingNonPmdWarnings(stringValue, annotation) == OptionalBool.NO) {
                unusedParts.add(this.makeAnnotationPartSuppressor(annotation, annotationParam, stringValue));
            } else {
                entireAnnotationIsUnused.setFalse();
            }
            return false;
        });
        if (anySuppressor.isTrue() && entireAnnotationIsUnused.isTrue()) {
            return Collections.singleton(this.makeFullAnnotationSuppressor(annotation));
        }
        return unusedParts;
    }

    private static boolean isPmdSuppressor(String stringValue) {
        return "PMD".equals(stringValue) || stringValue.startsWith("PMD.");
    }

    private SuppressorNodeImpl makeAnnotationPartSuppressor(A annotation, Node annotationPart, String stringValue) {
        String message = "Unnecessary suppression \"" + stringValue + "\" in " + this.getAnnotationName(annotation);
        return new SuppressorNodeImpl(annotationPart, message);
    }

    private SuppressorNodeImpl makeFullAnnotationSuppressor(A annotation) {
        String message = "Unnecessary " + this.getAnnotationName(annotation);
        return new SuppressorNodeImpl((Node)annotation, message);
    }

    private static int compareSpecificity(AnnotationPartWrapper fstPart, AnnotationPartWrapper sndPart) {
        String snd;
        String fst = fstPart.stringValue;
        if (fst.equals(snd = sndPart.stringValue)) {
            return 0;
        }
        if ("all".equals(snd)) {
            return 1;
        }
        if ("all".equals(fst)) {
            return -1;
        }
        if (!AbstractAnnotationSuppressor.isPmdSuppressor(snd)) {
            return 1;
        }
        if (!AbstractAnnotationSuppressor.isPmdSuppressor(fst)) {
            return -1;
        }
        if ("PMD".equals(snd)) {
            return 1;
        }
        if ("PMD".equals(fst)) {
            return -1;
        }
        throw AssertionUtil.shouldNotReachHere("Logically if we are here then both strings are of the form PMD.RuleName and should therefore be equal!");
    }

    protected static interface AnnotationWalkCallbacks {
        public boolean processNode(Node var1, @NonNull String var2);
    }

    private static final class AnnotationPartWrapper {
        private final Node node;
        private final String stringValue;

        private AnnotationPartWrapper(Node node, String stringValue) {
            this.node = node;
            this.stringValue = stringValue;
        }
    }

    private static final class SuppressorNodeImpl
    implements ViolationSuppressor.UnusedSuppressorNode {
        private final Node location;
        private final String message;

        SuppressorNodeImpl(Node node, String message) {
            this.location = node;
            this.message = message;
        }

        @Override
        public Reportable getLocation() {
            return this.location;
        }

        @Override
        public String unusedReason() {
            return this.message;
        }
    }
}

