/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.renderers.AbstractAccumulatingRenderer;
import net.sourceforge.pmd.reporting.Report;
import net.sourceforge.pmd.reporting.RuleViolation;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class YAHTMLRenderer
extends AbstractAccumulatingRenderer {
    public static final String NAME = "yahtml";
    public static final PropertyDescriptor<String> OUTPUT_DIR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.stringProperty("outputDir").desc("Output directory.")).defaultValue(".")).build();
    private SortedMap<String, ReportNode> reportNodesByPackage = new TreeMap<String, ReportNode>();

    public YAHTMLRenderer() {
        super(NAME, "Yet Another HTML format.");
        this.definePropertyDescriptor(OUTPUT_DIR);
    }

    @Override
    public String defaultFileExtension() {
        return "html";
    }

    private void addViolation(RuleViolation violation) {
        String packageName = violation.getAdditionalInfo().getOrDefault("packageName", "");
        String className = violation.getAdditionalInfo().getOrDefault("className", "");
        int index = packageName.indexOf(46, 0);
        while (index > -1) {
            String currentPackage = packageName.substring(0, index);
            ReportNode reportNode = (ReportNode)this.reportNodesByPackage.get(currentPackage);
            if (reportNode == null) {
                reportNode = new ReportNode(currentPackage);
                this.reportNodesByPackage.put(currentPackage, reportNode);
            }
            reportNode.incrementViolations();
            int oldIndex = index;
            if ((index = packageName.indexOf(46, index + 1)) != -1 || oldIndex == packageName.length()) continue;
            index = packageName.length();
        }
        String fqClassName = packageName + "." + className;
        ReportNode classNode = (ReportNode)this.reportNodesByPackage.get(fqClassName);
        if (classNode == null) {
            classNode = new ReportNode(packageName, className);
            this.reportNodesByPackage.put(fqClassName, classNode);
        }
        classNode.addRuleViolation(violation);
        ReportNode rootNode = (ReportNode)this.reportNodesByPackage.get(" <root> ");
        if (rootNode == null) {
            rootNode = new ReportNode("Aggregate");
            this.reportNodesByPackage.put(" <root> ", rootNode);
        }
        rootNode.incrementViolations();
    }

    @Override
    public void outputReport(Report report) throws IOException {
        String outputDir = this.getProperty(OUTPUT_DIR);
        for (RuleViolation ruleViolation : report.getViolations()) {
            this.addViolation(ruleViolation);
        }
        this.renderIndex(outputDir);
        this.renderClasses(outputDir);
        this.writer.println("<h3 align=\"center\">The HTML files are located " + (outputDir == null ? "above the project directory" : "in '" + outputDir + '\'') + ".</h3>");
    }

    private void renderIndex(String outputDir) throws IOException {
        try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(new File(outputDir, "index.html").toPath(), StandardCharsets.UTF_8, new OpenOption[0]));){
            out.println("<!DOCTYPE html>");
            out.println("<html>");
            out.println("    <head>");
            out.println("        <meta charset=\"UTF-8\">");
            out.println("        <title>PMD</title>");
            out.println("    </head>");
            out.println("    <body>");
            out.println("    <h2>Package View</h2>");
            out.println("    <table border=\"1\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\">");
            out.println("        <tr><th>Package</th><th>Class</th><th>#</th></tr>");
            for (ReportNode node : this.reportNodesByPackage.values()) {
                out.print("        <tr><td><b>");
                out.print(node.getPackageName());
                out.print("</b></td> <td>");
                if (node.hasViolations()) {
                    out.print("<a href=\"");
                    out.print(node.getClassName());
                    out.print(".html");
                    out.print("\">");
                    out.print(node.getClassName());
                    out.print("</a>");
                } else {
                    out.print(node.getClassName());
                }
                out.print("</td> <td>");
                out.print(node.getViolationCount());
                out.print("</td></tr>");
                out.println();
            }
            out.println("    </table>");
            out.println("    </body>");
            out.println("</html>");
        }
    }

    private void renderClasses(String outputDir) throws IOException {
        for (ReportNode node : this.reportNodesByPackage.values()) {
            if (!node.hasViolations()) continue;
            try (PrintWriter out = new PrintWriter(Files.newBufferedWriter(new File(outputDir, node.getClassName() + ".html").toPath(), StandardCharsets.UTF_8, new OpenOption[0]));){
                out.println("<!DOCTYPE html>");
                out.println("<html>");
                out.println("    <head>");
                out.println("        <meta charset=\"UTF-8\">");
                out.print("        <title>PMD - ");
                out.print(node.getClassName());
                out.println("</title>");
                out.println("    </head>");
                out.println("    <body>");
                out.println("        <h2>Class View</h2>");
                out.print("        <h3 align=\"center\">Class: ");
                out.print(node.getClassName());
                out.println("</h3>");
                out.println("        <table border=\"\" align=\"center\" cellspacing=\"0\" cellpadding=\"3\">");
                out.println("        <tr><th>Method</th><th>Violation</th></tr>");
                for (RuleViolation violation : node.getViolations()) {
                    out.print("        <tr><td>");
                    String methodName = violation.getAdditionalInfo().get("methodName");
                    out.print(StringUtil.nullToEmpty(methodName));
                    out.print("</td><td>");
                    out.print("<table border=\"0\">");
                    out.print(this.renderViolationRow("Rule:", violation.getRule().getName()));
                    out.print(this.renderViolationRow("Description:", violation.getDescription()));
                    String variableName = violation.getAdditionalInfo().get("variableName");
                    if (StringUtils.isNotBlank((CharSequence)variableName)) {
                        out.print(this.renderViolationRow("Variable:", variableName));
                    }
                    out.print(this.renderViolationRow("Line:", violation.getEndLine() > 0 ? violation.getBeginLine() + " and " + violation.getEndLine() : String.valueOf(violation.getBeginLine())));
                    out.print("</table>");
                    out.print("</td></tr>");
                    out.println();
                }
                out.println("        </table>");
                out.println("    </body>");
                out.println("</html>");
            }
        }
    }

    private String renderViolationRow(String name, String value) {
        return "<tr><td><b>" + name + "</b></td><td>" + value + "</td></tr>";
    }

    private static class ReportNode {
        private static final String ROOT_NODE_NAME = " <root> ";
        private final String packageName;
        private final String className;
        private int violationCount;
        private final List<RuleViolation> violations = new LinkedList<RuleViolation>();

        ReportNode(String packageName) {
            this.packageName = packageName;
            this.className = "-";
        }

        ReportNode(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }

        public void incrementViolations() {
            ++this.violationCount;
        }

        public void addRuleViolation(RuleViolation violation) {
            this.violations.add(violation);
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public int getViolationCount() {
            return this.violationCount + this.violations.size();
        }

        public List<RuleViolation> getViolations() {
            return this.violations;
        }

        public boolean hasViolations() {
            return !this.violations.isEmpty();
        }

        public String toString() {
            return "ReportNode[packageName=" + this.packageName + ",className=" + this.className + ",violationCount=" + this.violationCount + ",violations=" + this.violations.size() + "]";
        }
    }
}

