/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.io.Writer;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.properties.PropertySource;
import net.sourceforge.pmd.reporting.CloseHookFileListener;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.FileNameRenderer;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.ListenerInitializer;
import net.sourceforge.pmd.reporting.Report;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Renderer
extends PropertySource {
    @Override
    public String getName();

    public void setName(String var1);

    public String getDescription();

    public String defaultFileExtension();

    public void setDescription(String var1);

    public boolean isShowSuppressedViolations();

    public void setShowSuppressedViolations(boolean var1);

    public Writer getWriter();

    public void setFileNameRenderer(FileNameRenderer var1);

    public void setWriter(Writer var1);

    public void start() throws IOException;

    public void startFileAnalysis(TextFile var1);

    public void renderFileReport(Report var1) throws IOException;

    public void end() throws IOException;

    public void flush() throws IOException;

    public void setReportFile(String var1);

    default public GlobalAnalysisListener newListener() throws IOException {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
            this.start();
        }
        return new GlobalAnalysisListener(){
            final Object reportMergeLock = new Object();
            final Report.GlobalReportBuilderListener configErrorReport = new Report.GlobalReportBuilderListener();

            @Override
            public void onConfigError(Report.ConfigurationError error) {
                this.configErrorReport.onConfigError(error);
            }

            @Override
            public ListenerInitializer initializer() {
                return new ListenerInitializer(){

                    @Override
                    public void setFileNameRenderer(FileNameRenderer fileNameRenderer) {
                        Renderer.this.setFileNameRenderer(fileNameRenderer);
                    }
                };
            }

            @Override
            public FileAnalysisListener startFileAnalysis(TextFile file) {
                final Renderer renderer = Renderer.this;
                renderer.startFileAnalysis(file);
                return new CloseHookFileListener<Report.ReportBuilderListener>(new Report.ReportBuilderListener()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected void doClose(Report.ReportBuilderListener reportBuilder, @Nullable Exception ignoredEx) throws Exception {
                        reportBuilder.close();
                        Object object = reportMergeLock;
                        synchronized (object) {
                            try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
                                renderer.renderFileReport((Report)reportBuilder.getResult());
                            }
                        }
                    }

                    @Override
                    public String toString() {
                        return "FileRendererListener[" + Renderer.this + "]";
                    }
                };
            }

            @Override
            public void close() throws Exception {
                this.configErrorReport.close();
                Renderer.this.renderFileReport((Report)this.configErrorReport.getResult());
                try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
                    Renderer.this.end();
                    Renderer.this.flush();
                }
            }
        };
    }
}

