/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;
import net.sourceforge.pmd.internal.util.IOUtil;
import net.sourceforge.pmd.lang.document.FileId;
import net.sourceforge.pmd.properties.AbstractPropertySource;
import net.sourceforge.pmd.renderers.Renderer;
import net.sourceforge.pmd.reporting.FileNameRenderer;

public abstract class AbstractRenderer
extends AbstractPropertySource
implements Renderer {
    protected String name;
    protected String description;
    protected boolean showSuppressedViolations = true;
    protected PrintWriter writer;
    private FileNameRenderer fileNameRenderer = fileId -> fileId.getOriginalPath();

    public AbstractRenderer(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    protected String getPropertySourceType() {
        return "renderer";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean isShowSuppressedViolations() {
        return this.showSuppressedViolations;
    }

    @Override
    public void setShowSuppressedViolations(boolean showSuppressedViolations) {
        this.showSuppressedViolations = showSuppressedViolations;
    }

    @Override
    public void setFileNameRenderer(FileNameRenderer fileNameRenderer) {
        this.fileNameRenderer = Objects.requireNonNull(fileNameRenderer);
    }

    protected final String determineFileName(FileId fileId) {
        return this.fileNameRenderer.getDisplayName(fileId);
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = new PrintWriter(writer);
    }

    @Override
    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public void flush() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.flush();
        }
        finally {
            IOUtil.closeQuietly(this.writer);
        }
    }

    @Override
    public void setReportFile(String reportFilename) {
        this.setWriter(IOUtil.createWriter(reportFilename));
    }
}

