/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.renderers;

import java.io.IOException;
import java.util.Objects;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperation;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.lang.document.TextFile;
import net.sourceforge.pmd.renderers.AbstractRenderer;
import net.sourceforge.pmd.reporting.FileAnalysisListener;
import net.sourceforge.pmd.reporting.GlobalAnalysisListener;
import net.sourceforge.pmd.reporting.Report;

public abstract class AbstractAccumulatingRenderer
extends AbstractRenderer {
    public AbstractAccumulatingRenderer(String name, String description) {
        super(name, description);
    }

    @Override
    public void start() throws IOException {
    }

    @Override
    public void end() throws IOException {
    }

    @Override
    public void startFileAnalysis(TextFile dataSource) {
        Objects.requireNonNull(dataSource);
    }

    @Override
    public final void renderFileReport(Report report) throws IOException {
        Objects.requireNonNull(report);
    }

    protected abstract void outputReport(Report var1) throws IOException;

    @Override
    public GlobalAnalysisListener newListener() throws IOException {
        try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
            this.start();
        }
        return new GlobalAnalysisListener(){
            final Report.GlobalReportBuilderListener reportBuilder = new Report.GlobalReportBuilderListener();

            @Override
            public FileAnalysisListener startFileAnalysis(TextFile file) {
                AbstractAccumulatingRenderer.this.startFileAnalysis(file);
                return this.reportBuilder.startFileAnalysis(file);
            }

            @Override
            public void onConfigError(Report.ConfigurationError error) {
                this.reportBuilder.onConfigError(error);
            }

            @Override
            public void close() throws Exception {
                this.reportBuilder.close();
                try (TimedOperation ignored = TimeTracker.startOperation(TimedOperationCategory.REPORTING);){
                    AbstractAccumulatingRenderer.this.outputReport((Report)this.reportBuilder.getResult());
                    AbstractAccumulatingRenderer.this.end();
                    AbstractAccumulatingRenderer.this.flush();
                }
            }
        };
    }
}

