/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath.impl;

import java.util.Objects;
import javax.xml.namespace.QName;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.rule.xpath.impl.XPathFunctionException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class XPathFunctionDefinition {
    private static final String PMD_URI_PREFIX = "http://pmd.sourceforge.net/";
    private final QName qname;

    private XPathFunctionDefinition(String localName, String namespacePrefix, String uri) {
        this.qname = new QName(uri, localName, namespacePrefix);
    }

    protected XPathFunctionDefinition(String localName) {
        this(localName, "pmd", "http://pmd.sourceforge.net/pmd-core");
    }

    protected XPathFunctionDefinition(String localName, Language language) {
        this(localName, "pmd-" + language.getId(), "http://pmd.sourceforge.net/pmd-" + language.getId());
    }

    public final QName getQName() {
        return this.qname;
    }

    public Type[] getArgumentTypes() {
        return new Type[0];
    }

    public abstract Type getResultType();

    public boolean dependsOnContext() {
        return false;
    }

    public abstract FunctionCall makeCallExpression();

    public int hashCode() {
        return Objects.hashCode(this.qname);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPathFunctionDefinition that = (XPathFunctionDefinition)o;
        return Objects.equals(this.qname, that.qname);
    }

    public static enum Type {
        SINGLE_STRING,
        SINGLE_BOOLEAN,
        SINGLE_INTEGER,
        SINGLE_ELEMENT,
        STRING_SEQUENCE,
        OPTIONAL_STRING,
        OPTIONAL_DECIMAL;

    }

    public static interface FunctionCall {
        public Object call(@Nullable Node var1, Object[] var2) throws XPathFunctionException;

        default public void staticInit(Object[] arguments) throws XPathFunctionException {
        }
    }
}

