/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import net.sf.saxon.trans.XPathException;
import net.sourceforge.pmd.lang.rule.xpath.XPathVersion;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PmdXPathException
extends ContextedRuntimeException {
    private static final String ERROR_KIND = "Kind";
    private static final String ERROR_PHASE = "Phase";
    private static final String EXPR = "Expression";
    private static final String VERSION = "Version";
    private static final String RULE_NAME = "Rule";
    private static final String LOCATION = "Location in expr";

    public PmdXPathException(XPathException e, Phase phase, String expression, XPathVersion version) {
        super((Throwable)e);
        this.setContextValue(ERROR_KIND, this.getErrorKind(e));
        this.setContextValue(ERROR_PHASE, (Object)phase);
        this.setContextValue(EXPR, expression);
        this.setContextValue(VERSION, (Object)version);
        this.setContextValue(LOCATION, e.getLocationAsString());
    }

    public Phase getPhase() {
        return (Phase)((Object)this.getFirstContextValue(ERROR_PHASE));
    }

    public PmdXPathException addRuleName(String ruleName) {
        this.setContextValue(RULE_NAME, ruleName);
        return this;
    }

    public @Nullable String getRuleName() {
        return (String)this.getFirstContextValue(RULE_NAME);
    }

    private String getErrorKind(XPathException e) {
        if (e.isSyntaxError()) {
            return "Syntax error";
        }
        if (e.isTypeError()) {
            return "Type error";
        }
        if (e.isStaticError()) {
            return "Static error";
        }
        return "Unknown error";
    }

    public static enum Phase {
        INITIALIZATION,
        EVALUATION;

    }
}

