/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import net.sourceforge.pmd.PMDConfiguration;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.rule.Rule;
import net.sourceforge.pmd.lang.rule.RulePriority;
import net.sourceforge.pmd.lang.rule.RuleSet;
import net.sourceforge.pmd.lang.rule.RuleSetFactory;
import net.sourceforge.pmd.lang.rule.RuleSetLoadException;
import net.sourceforge.pmd.lang.rule.internal.RuleSetReferenceId;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.internal.ResourceLoader;
import net.sourceforge.pmd.util.log.PmdReporter;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RuleSetLoader {
    private static final Logger LOG = LoggerFactory.getLogger(RuleSetLoader.class);
    private LanguageRegistry languageRegistry = LanguageRegistry.PMD;
    private ResourceLoader resourceLoader = new ResourceLoader(RuleSetLoader.class.getClassLoader());
    private RulePriority minimumPriority = RulePriority.LOW;
    private boolean warnDeprecated = true;
    private boolean includeDeprecatedRuleReferences = false;
    private @NonNull PmdReporter reporter = PmdReporter.quiet();

    RuleSetLoader withReporter(@NonNull PmdReporter reporter) {
        this.reporter = Objects.requireNonNull(reporter);
        return this;
    }

    public RuleSetLoader loadResourcesWith(ClassLoader classLoader) {
        this.resourceLoader = new ResourceLoader(classLoader);
        return this;
    }

    RuleSetLoader loadResourcesWith(ResourceLoader loader) {
        this.resourceLoader = loader;
        return this;
    }

    public RuleSetLoader withLanguages(LanguageRegistry languageRegistry) {
        this.languageRegistry = languageRegistry;
        return this;
    }

    public RuleSetLoader filterAbovePriority(RulePriority minimumPriority) {
        this.minimumPriority = minimumPriority;
        return this;
    }

    public RuleSetLoader warnDeprecated(boolean warn) {
        this.warnDeprecated = warn;
        return this;
    }

    public RuleSetLoader includeDeprecatedRuleReferences(boolean enable) {
        this.includeDeprecatedRuleReferences = enable;
        return this;
    }

    RuleSetFactory toFactory() {
        return new RuleSetFactory(this.resourceLoader, this.languageRegistry, this.minimumPriority, this.warnDeprecated, this.includeDeprecatedRuleReferences, this.reporter);
    }

    public RuleSet loadFromResource(String rulesetPath) {
        return this.loadFromResource(new RuleSetReferenceId(rulesetPath, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuleSet loadFromString(final String filename, final String rulesetXmlContent) {
        if (filename == null || filename.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty filename");
        }
        final ResourceLoader oldLoader = this.resourceLoader;
        try {
            this.loadResourcesWith(new ResourceLoader(){

                @Override
                public @NonNull InputStream loadResourceAsStream(String name) throws IOException {
                    if (Objects.equals(name, filename)) {
                        return new ByteArrayInputStream(rulesetXmlContent.getBytes(StandardCharsets.UTF_8));
                    }
                    return oldLoader.loadResourceAsStream(name);
                }
            });
            RuleSet ruleSet = this.loadFromResource(new RuleSetReferenceId(filename, null));
            return ruleSet;
        }
        finally {
            this.loadResourcesWith(oldLoader);
        }
    }

    public List<RuleSet> loadFromResources(Collection<String> paths) {
        ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>(paths.size());
        for (String path : paths) {
            ruleSets.add(this.loadFromResource(path));
        }
        return ruleSets;
    }

    List<RuleSet> loadRuleSetsWithoutException(List<String> rulesetPaths) {
        ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>(rulesetPaths.size());
        boolean anyRules = false;
        boolean error = false;
        for (String path : rulesetPaths) {
            try {
                RuleSet ruleset = this.loadFromResource(path);
                anyRules |= !ruleset.getRules().isEmpty();
                this.printRulesInDebug(path, ruleset);
                ruleSets.add(ruleset);
            }
            catch (RuleSetLoadException e) {
                error = true;
                this.reporter.error(e);
            }
        }
        if (!anyRules && !error) {
            this.reporter.warn("No rules found. Maybe you misspelled a rule name? ({0})", StringUtils.join(rulesetPaths, (char)','));
        }
        return ruleSets;
    }

    void printRulesInDebug(String path, RuleSet ruleset) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Rules loaded from {}:", (Object)path);
            for (Rule rule : ruleset.getRules()) {
                LOG.debug("- {} ({})", (Object)rule.getName(), (Object)rule.getLanguage().getName());
            }
        }
        if (ruleset.getRules().isEmpty()) {
            this.reporter.warn("No rules found in ruleset {0}", path);
        }
    }

    public List<RuleSet> loadFromResources(String first, String ... rest) {
        return this.loadFromResources(CollectionUtil.listOf(first, rest));
    }

    RuleSet loadFromResource(RuleSetReferenceId ruleSetReferenceId) {
        try {
            return this.toFactory().createRuleSet(ruleSetReferenceId);
        }
        catch (RuleSetLoadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuleSetLoadException(ruleSetReferenceId, (Throwable)e);
        }
    }

    public static RuleSetLoader fromPmdConfig(PMDConfiguration configuration) {
        return new RuleSetLoader().filterAbovePriority(configuration.getMinimumPriority()).withLanguages(configuration.getLanguageRegistry()).withReporter(configuration.getReporter());
    }

    public List<RuleSet> getStandardRuleSets() {
        ArrayList<String> ruleSetReferenceIds = new ArrayList<String>();
        for (Language language : this.languageRegistry.getLanguages()) {
            Properties props = new Properties();
            String rulesetsProperties = "category/" + language.getId() + "/categories.properties";
            try {
                InputStream inputStream = this.resourceLoader.loadClassPathResourceAsStreamOrThrow(rulesetsProperties);
                try {
                    props.load(inputStream);
                    String rulesetFilenames = props.getProperty("rulesets.filenames");
                    if (!StringUtils.isNotBlank((CharSequence)rulesetFilenames)) continue;
                    ruleSetReferenceIds.addAll(Arrays.asList(rulesetFilenames.split(",")));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't find " + rulesetsProperties + "; please ensure that the directory is on the classpath. The current classpath is: " + System.getProperty("java.class.path"));
            }
        }
        ArrayList<RuleSet> ruleSets = new ArrayList<RuleSet>();
        for (String id : ruleSetReferenceIds) {
            ruleSets.add(this.loadFromResource(id));
        }
        return ruleSets;
    }
}

