/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.internal;

import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.util.IteratorUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
interface Filtermap<I, O>
extends Function<I, O>,
Predicate<I> {
    public static final Filtermap<Node, Node> NODE_IDENTITY = Filtermap.identityFilter();

    @Override
    public @Nullable O apply(@Nullable I var1);

    @Override
    default public boolean test(@Nullable I i) {
        return this.apply(i) != null;
    }

    default public Iterator<O> filterMap(Iterator<? extends I> iter) {
        return IteratorUtil.mapNotNull(iter, this);
    }

    default public <R> Filtermap<I, R> thenApply(Function<@NonNull ? super O, @Nullable ? extends R> then) {
        Objects.requireNonNull(then);
        return i -> {
            if (i == null) {
                return null;
            }
            O o = this.apply((I)i);
            return o == null ? null : then.apply((O)o);
        };
    }

    default public <R> Filtermap<I, R> thenCast(Class<? extends R> rClass) {
        return this.thenApply(Filtermap.isInstance(rClass));
    }

    default public Filtermap<I, O> thenFilter(Predicate<? super O> rClass) {
        return this.thenApply(Filtermap.filter(rClass));
    }

    public static <I> Filtermap<I, I> identityFilter() {
        return new Filtermap<I, I>(){

            @Override
            public I apply(@Nullable I i) {
                return i;
            }

            @Override
            public <R> Filtermap<I, R> thenApply(Function<@NonNull ? super I, @Nullable ? extends R> then) {
                return then instanceof Filtermap ? (Filtermap)then : Filtermap.super.thenApply(then);
            }

            @Override
            public Iterator<I> filterMap(Iterator<? extends I> iter) {
                return iter;
            }

            public String toString() {
                return "IdentityFilter";
            }
        };
    }

    public static <I extends O, O> Filtermap<I, O> filter(Predicate<? super @NonNull I> pred) {
        return i -> i != null && pred.test((Object)i) ? i : null;
    }

    public static <I, O> Filtermap<I, O> isInstance(final Class<? extends O> oClass) {
        if (oClass == Node.class) {
            return NODE_IDENTITY;
        }
        return new Filtermap<I, O>(){

            @Override
            public @Nullable O apply(@Nullable I i) {
                return oClass.isInstance(i) ? i : null;
            }

            public String toString() {
                return "IsInstance[" + oClass + "]";
            }
        };
    }
}

