/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.impl.TokenDocument;
import net.sourceforge.pmd.lang.ast.impl.javacc.CharStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.TextDocument;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaccTokenDocument
extends TokenDocument<JavaccToken> {
    private final TokenDocumentBehavior behavior;
    private JavaccToken first;

    public JavaccTokenDocument(TextDocument textDocument, TokenDocumentBehavior behavior) {
        super(textDocument);
        this.behavior = behavior;
    }

    boolean useMarkSuffix() {
        return this.behavior.useMarkSuffix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaccToken open() {
        JavaccTokenDocument javaccTokenDocument = this;
        synchronized (javaccTokenDocument) {
            if (this.first != null) {
                throw new RuntimeException("Document is already opened");
            }
            this.first = JavaccToken.newImplicit(0, this);
        }
        return this.first;
    }

    @Override
    public JavaccToken getFirstToken() {
        if (this.first == null || this.first.next == null) {
            throw new IllegalStateException("Document has not been opened");
        }
        return this.first.next;
    }

    public @NonNull String describeKind(int kind) {
        return this.behavior.describeKind(kind);
    }

    public JavaccToken createToken(int kind, CharStream cs, @Nullable String image) {
        return this.behavior.createToken(this, kind, cs, image);
    }

    public static class TokenDocumentBehavior {
        public static final TokenDocumentBehavior DEFAULT = new TokenDocumentBehavior(Collections.emptyList());
        private final List<String> tokenNames;

        public TokenDocumentBehavior(List<String> tokenNames) {
            this.tokenNames = tokenNames;
        }

        public boolean useMarkSuffix() {
            return false;
        }

        public TextDocument translate(TextDocument text) throws MalformedSourceException {
            return text;
        }

        public final @NonNull String describeKind(int kind) {
            if (kind == -1) {
                return "<implicit token>";
            }
            String impl = this.describeKindImpl(kind);
            if (impl != null) {
                return impl;
            }
            return "<token of kind " + kind + ">";
        }

        protected @Nullable String describeKindImpl(int kind) {
            if (kind >= 0 && kind < this.tokenNames.size()) {
                return this.tokenNames.get(kind);
            }
            return null;
        }

        public JavaccToken createToken(JavaccTokenDocument self, int kind, CharStream cs, @Nullable String image) {
            return new JavaccToken(kind, image == null ? cs.getTokenImageCs() : image, cs.getStartOffset(), cs.getEndOffset(), self);
        }
    }
}

