/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.impl.javacc;

import net.sourceforge.pmd.lang.ast.impl.javacc.MalformedSourceException;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.document.FragmentedDocBuilder;
import net.sourceforge.pmd.lang.document.TextDocument;
import net.sourceforge.pmd.util.AssertionUtil;

public abstract class EscapeTranslator {
    protected Chars input;
    protected int bufpos;
    final FragmentedDocBuilder builder;
    private Chars curEscape;
    private int offInEscape;

    public EscapeTranslator(TextDocument original) {
        AssertionUtil.requireParamNotNull("builder", original);
        this.input = original.getText();
        this.bufpos = 0;
        this.builder = new FragmentedDocBuilder(original);
    }

    public TextDocument translateDocument() throws MalformedSourceException {
        this.ensureOpen();
        try {
            TextDocument textDocument = this.translateImpl();
            return textDocument;
        }
        finally {
            this.close();
        }
    }

    private TextDocument translateImpl() {
        if (this.bufpos == this.input.length()) {
            return this.builder.build();
        }
        int len = this.input.length();
        int readChars = 0;
        while (readChars < len && (this.bufpos < this.input.length() || this.curEscape != null)) {
            if (this.curEscape != null) {
                int toRead = Integer.min(len - readChars, this.curEscape.length() - this.offInEscape);
                readChars += toRead;
                this.offInEscape += toRead;
                if (this.curEscape.length() != this.offInEscape) break;
                this.curEscape = null;
                continue;
            }
            int bpos = this.bufpos;
            int nextJump = this.gobbleMaxWithoutEscape(Integer.min(this.input.length(), bpos + len - readChars));
            int newlyReadChars = nextJump - bpos;
            assert (newlyReadChars >= 0 && readChars + newlyReadChars <= len);
            if (newlyReadChars == 0 && nextJump == this.input.length()) break;
            readChars += newlyReadChars;
        }
        return this.builder.build();
    }

    protected int gobbleMaxWithoutEscape(int maxOff) throws MalformedSourceException {
        this.bufpos = maxOff;
        return maxOff;
    }

    protected int recordEscape(int startOffsetInclusive, int endOffsetExclusive, Chars translation) {
        assert (endOffsetExclusive > startOffsetInclusive && startOffsetInclusive >= 0);
        this.builder.recordDelta(startOffsetInclusive, endOffsetExclusive, translation);
        this.bufpos = endOffsetExclusive;
        this.curEscape = translation;
        this.offInEscape = 0;
        return startOffsetInclusive;
    }

    private void close() {
        this.bufpos = -1;
        this.input = null;
    }

    protected final void ensureOpen() {
        if (this.input == null) {
            throw new IllegalStateException("Closed");
        }
    }

    protected FileLocation locationAt(int indexInInput) {
        return this.builder.toLocation(indexInInput);
    }
}

