/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LanguageVersionDiscoverer {
    private LanguageRegistry languageRegistry;
    private final Map<Language, LanguageVersion> languageToLanguageVersion = new HashMap<Language, LanguageVersion>();
    private LanguageVersion forcedVersion;

    public LanguageVersionDiscoverer(LanguageRegistry registry, LanguageVersion forcedVersion) {
        this.languageRegistry = registry;
        this.forcedVersion = forcedVersion;
    }

    public LanguageVersionDiscoverer(LanguageRegistry registry) {
        this(registry, null);
    }

    public LanguageVersion setDefaultLanguageVersion(LanguageVersion languageVersion) {
        AssertionUtil.requireParamNotNull("languageVersion", languageVersion);
        LanguageVersion currentLanguageVersion = this.languageToLanguageVersion.put(languageVersion.getLanguage(), languageVersion);
        if (currentLanguageVersion == null) {
            currentLanguageVersion = languageVersion.getLanguage().getDefaultVersion();
        }
        return currentLanguageVersion;
    }

    public LanguageVersion getDefaultLanguageVersion(Language language) {
        Objects.requireNonNull(language);
        LanguageVersion languageVersion = this.languageToLanguageVersion.get(language);
        if (languageVersion == null) {
            languageVersion = language.getDefaultVersion();
        }
        return languageVersion;
    }

    public LanguageVersion getDefaultLanguageVersionForFile(File sourceFile) {
        return this.getDefaultLanguageVersionForFile(sourceFile.getName());
    }

    public @Nullable LanguageVersion getDefaultLanguageVersionForFile(String fileName) {
        List<Language> languages = this.getLanguagesForFile(fileName);
        LanguageVersion languageVersion = null;
        if (!languages.isEmpty()) {
            languageVersion = this.getDefaultLanguageVersion(languages.get(0));
        }
        return languageVersion;
    }

    public LanguageVersion getForcedVersion() {
        return this.forcedVersion;
    }

    public void setForcedVersion(LanguageVersion forceLanguageVersion) {
        this.forcedVersion = forceLanguageVersion;
    }

    public List<Language> getLanguagesForFile(String fileName) {
        String extension = this.getExtension(fileName);
        List<Language> matching = this.languageRegistry.getLanguages().stream().filter(it -> it.hasExtension(extension)).collect(CollectionUtil.toMutableList());
        if (matching.size() > 1) {
            matching.removeIf(l -> CollectionUtil.any(matching, it -> it.isDialectOf((Language)l)));
        }
        return matching;
    }

    private String getExtension(String fileName) {
        return StringUtils.substringAfterLast((String)fileName, (String)".");
    }

    public void onlyRecognizeLanguages(LanguageRegistry lang) {
        this.languageRegistry = Objects.requireNonNull(lang);
    }

    public String toString() {
        return "LanguageVersionDiscoverer(" + this.languageRegistry + (this.forcedVersion != null ? ",forcedVersion=" + this.forcedVersion : "") + ")";
    }
}

