/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.annotation.Experimental;
import net.sourceforge.pmd.lang.Language;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.PmdCapableLanguage;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class LanguageModuleBase
implements Language {
    private final LanguageMetadata meta;
    private final List<LanguageVersion> distinctVersions;
    private final Map<String, LanguageVersion> byName;
    private final LanguageVersion defaultVersion;
    private final Set<String> dependencies;
    private final @Nullable String baseLanguageId;

    protected LanguageModuleBase(LanguageMetadata metadata) {
        this(metadata, null);
    }

    @Experimental
    protected LanguageModuleBase(DialectLanguageMetadata metadata) {
        this(metadata.metadata, metadata.baseLanguageId);
    }

    private LanguageModuleBase(LanguageMetadata metadata, String baseLanguageId) {
        this.meta = metadata;
        metadata.validate();
        this.dependencies = Collections.unmodifiableSet(metadata.dependencies);
        this.baseLanguageId = baseLanguageId;
        ArrayList<LanguageVersion> versions = new ArrayList<LanguageVersion>();
        HashMap<String, LanguageVersion> byName = new HashMap<String, LanguageVersion>();
        LanguageVersion defaultVersion = null;
        if (metadata.versionMetadata.isEmpty()) {
            if (this instanceof PmdCapableLanguage) {
                throw new IllegalStateException("No versions for '" + this.getId() + "'");
            }
            metadata.versionMetadata.add(new LanguageMetadata.LangVersionMetadata());
        }
        int i = 0;
        for (LanguageMetadata.LangVersionMetadata versionId : metadata.versionMetadata) {
            String versionStr = versionId.name;
            LanguageVersion languageVersion = new LanguageVersion(this, versionStr, i++, versionId.aliases);
            versions.add(languageVersion);
            LanguageModuleBase.checkNotPresent(byName, versionStr);
            byName.put(versionStr, languageVersion);
            for (String alias : versionId.aliases) {
                LanguageModuleBase.checkNotPresent(byName, alias);
                byName.put(alias, languageVersion);
            }
            if (!versionId.isDefault) continue;
            if (defaultVersion != null) {
                throw new IllegalStateException("Default version already set to " + defaultVersion + ", cannot set it to " + languageVersion);
            }
            defaultVersion = languageVersion;
        }
        this.byName = Collections.unmodifiableMap(byName);
        this.distinctVersions = Collections.unmodifiableList(versions);
        this.defaultVersion = Objects.requireNonNull(defaultVersion, "No default version for " + this.getId());
    }

    private static void checkNotPresent(Map<String, ?> map, String alias) {
        if (map.containsKey(alias)) {
            throw new IllegalArgumentException("Version key '" + alias + "' is duplicated");
        }
    }

    @Override
    public @Nullable String getBaseLanguageId() {
        return this.baseLanguageId;
    }

    @Override
    public List<LanguageVersion> getVersions() {
        return this.distinctVersions;
    }

    @Override
    public @NonNull LanguageVersion getDefaultVersion() {
        return this.defaultVersion;
    }

    @Override
    public LanguageVersion getVersion(String version) {
        return this.byName.get(version);
    }

    @Override
    public Set<String> getVersionNamesAndAliases() {
        return Collections.unmodifiableSet(this.byName.keySet());
    }

    @Override
    public Set<String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public String getName() {
        return this.meta.name;
    }

    @Override
    public String getShortName() {
        return this.meta.getShortName();
    }

    @Override
    public String getId() {
        return this.meta.id;
    }

    @Override
    public @NonNull List<String> getExtensions() {
        return Collections.unmodifiableList(this.meta.extensions);
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public int compareTo(Language o) {
        return this.getName().compareTo(o.getName());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LanguageModuleBase other = (LanguageModuleBase)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public static final class LanguageMetadata {
        private static final Pattern VALID_LANG_ID = Pattern.compile("[a-z][_a-z0-9]*");
        private static final Pattern SPACE_PAT = Pattern.compile("\\s");
        private final Set<String> dependencies = new HashSet<String>();
        private String name;
        private @Nullable String shortName;
        private final @NonNull String id;
        private List<String> extensions;
        private final List<LangVersionMetadata> versionMetadata = new ArrayList<LangVersionMetadata>();

        private LanguageMetadata(@NonNull String id) {
            this.id = id;
            LanguageMetadata.checkValidLangId(id);
        }

        void validate() {
            AssertionUtil.validateState(this.name != null, "Language " + this.id + " should have a name");
            AssertionUtil.validateState(this.extensions != null, "Language " + this.id + " has not registered any file extensions");
        }

        String getShortName() {
            return this.shortName == null ? this.name : this.shortName;
        }

        public static LanguageMetadata withId(@NonNull String id) {
            return new LanguageMetadata(id);
        }

        public LanguageMetadata name(@NonNull String name) {
            AssertionUtil.requireParamNotNull("name", name);
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("Not a valid language name: " + StringUtil.inSingleQuotes(name));
            }
            this.name = name.trim();
            return this;
        }

        public LanguageMetadata shortName(@NonNull String shortName) {
            AssertionUtil.requireParamNotNull("short name", shortName);
            if (StringUtils.isBlank((CharSequence)this.name)) {
                throw new IllegalArgumentException("Not a valid language name: " + StringUtil.inSingleQuotes(this.name));
            }
            this.shortName = shortName.trim();
            return this;
        }

        public LanguageMetadata extensions(String extensionWithoutPeriod, String ... others) {
            this.extensions = new ArrayList<String>(CollectionUtil.setOf(extensionWithoutPeriod, others));
            AssertionUtil.requireContainsNoNullValue("extensions", this.extensions);
            return this;
        }

        public LanguageMetadata extensions(Collection<String> extensions) {
            this.extensions = new ArrayList<String>(new HashSet<String>(extensions));
            AssertionUtil.requireContainsNoNullValue("extensions", this.extensions);
            if (this.extensions.isEmpty()) {
                throw new IllegalArgumentException("At least one extension is required.");
            }
            return this;
        }

        public LanguageMetadata addVersion(String name, String ... aliases) {
            this.versionMetadata.add(new LangVersionMetadata(name, Arrays.asList(aliases), false));
            return this;
        }

        public LanguageMetadata addDefaultVersion(String name, String ... aliases) {
            this.versionMetadata.add(new LangVersionMetadata(name, Arrays.asList(aliases), true));
            return this;
        }

        public LanguageMetadata addAllVersionsOf(Language language) {
            for (LanguageVersion version : language.getVersions()) {
                this.versionMetadata.add(new LangVersionMetadata(version.getVersion(), version.getAliases(), version.equals(language.getDefaultVersion())));
            }
            return this;
        }

        @Experimental
        public DialectLanguageMetadata asDialectOf(String baseLanguageId) {
            LanguageMetadata.checkValidLangId(baseLanguageId);
            this.dependsOnLanguage(baseLanguageId);
            return new DialectLanguageMetadata(this, baseLanguageId);
        }

        private static void checkValidLangId(String id) {
            if (!VALID_LANG_ID.matcher(id).matches()) {
                throw new IllegalArgumentException("ID '" + id + "' is not a valid language ID (should match " + VALID_LANG_ID + ").");
            }
        }

        public LanguageMetadata dependsOnLanguage(String id) {
            LanguageMetadata.checkValidLangId(id);
            this.dependencies.add(id);
            return this;
        }

        static final class LangVersionMetadata {
            final String name;
            final List<String> aliases;
            final boolean isDefault;

            private LangVersionMetadata() {
                this.name = "";
                this.aliases = CollectionUtil.emptyList();
                this.isDefault = true;
            }

            private LangVersionMetadata(String name, List<String> aliases, boolean isDefault) {
                LangVersionMetadata.checkVersionName(name);
                for (String alias : aliases) {
                    LangVersionMetadata.checkVersionName(alias);
                }
                this.name = name;
                this.aliases = aliases;
                this.isDefault = isDefault;
            }

            private static void checkVersionName(String name) {
                if (StringUtils.isBlank((CharSequence)name) || SPACE_PAT.matcher(name).find()) {
                    throw new IllegalArgumentException("Invalid version name: " + StringUtil.inSingleQuotes(name));
                }
            }
        }
    }

    @Experimental
    public static final class DialectLanguageMetadata {
        private final @NonNull LanguageMetadata metadata;
        private final @NonNull String baseLanguageId;

        private DialectLanguageMetadata(LanguageMetadata metadata, String baseLanguageId) {
            this.metadata = metadata;
            this.baseLanguageId = baseLanguageId;
        }
    }
}

