/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd.impl;

import java.io.IOException;
import net.sourceforge.pmd.cpd.CpdLexer;
import net.sourceforge.pmd.cpd.TokenFactory;
import net.sourceforge.pmd.cpd.impl.BaseTokenFilter;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.document.TextDocument;

public abstract class CpdLexerBase<T extends GenericToken<T>>
implements CpdLexer {
    protected abstract TokenManager<T> makeLexerImpl(TextDocument var1) throws IOException;

    protected TokenManager<T> filterTokenStream(TokenManager<T> tokenManager) {
        return new BaseTokenFilter<T>(tokenManager);
    }

    protected void processToken(TokenFactory tokenEntries, T currentToken) {
        tokenEntries.recordToken(this.getImage(currentToken), currentToken.getReportLocation());
    }

    protected String getImage(T token) {
        return token.getImage();
    }

    @Override
    public final void tokenize(TextDocument document, TokenFactory tokens) throws IOException {
        TokenManager<T> tokenManager = this.filterTokenStream(this.makeLexerImpl(document));
        T currentToken = tokenManager.getNextToken();
        while (currentToken != null) {
            this.processToken(tokens, currentToken);
            currentToken = tokenManager.getNextToken();
        }
    }
}

