/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.cpd.CPDReport;
import net.sourceforge.pmd.cpd.CPDReportRenderer;
import net.sourceforge.pmd.cpd.Mark;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.document.FileLocation;
import org.apache.commons.lang3.StringUtils;

public class MarkdownRenderer
implements CPDReportRenderer {
    private static final String SEPARATOR = "\n---\n\n";
    private static final String FOUND_DUPLICATION_TEMPLATE = "Found a %d line (%d tokens) duplication in the following files:\n";
    private static final String STARTING_AT_LINE_TEMPLATE = "* Starting at line %d of %s\n";

    @Override
    public void render(CPDReport report, Writer writer) throws IOException {
        Iterator<Match> matches = report.getMatches().iterator();
        if (matches.hasNext()) {
            this.renderDuplication(report, writer, matches.next());
        }
        while (matches.hasNext()) {
            Match match = matches.next();
            writer.write(SEPARATOR);
            this.renderDuplication(report, writer, match);
        }
        writer.flush();
    }

    private void renderDuplication(CPDReport report, Writer writer, Match match) throws IOException {
        writer.append(String.format(FOUND_DUPLICATION_TEMPLATE, match.getLineCount(), match.getTokenCount()));
        for (Mark mark : match) {
            FileLocation loc = mark.getLocation();
            writer.append(String.format(STARTING_AT_LINE_TEMPLATE, loc.getStartLine(), report.getDisplayName(loc.getFileId())));
        }
        Mark firstMark = match.getFirstMark();
        String filename = firstMark.getFileId().getFileName().toLowerCase(Locale.ROOT);
        String highlightLanguage = null;
        if (filename.endsWith(".java") || filename.endsWith(".jav")) {
            highlightLanguage = "java";
        }
        Chars source = report.getSourceCodeSlice(firstMark);
        MarkdownCodeBlock markdownCodeBlock = new MarkdownCodeBlock(source, highlightLanguage);
        writer.append(markdownCodeBlock.toString());
    }

    static class MarkdownCodeBlock {
        private static final int MIN_CODE_FENCE_LENGTH = 3;
        private static final Pattern CODE_FENCE_PATTERN = Pattern.compile(String.format("`{%d,}", 3));
        private final CharSequence source;
        private final String highlightLanguage;

        MarkdownCodeBlock(CharSequence source, String highlightLanguage) {
            this.source = source;
            this.highlightLanguage = highlightLanguage != null ? highlightLanguage : "";
        }

        private int calculateFenceLength() {
            String defaultCodeFence = StringUtils.repeat((String)"`", (int)3);
            if (!this.source.toString().contains(defaultCodeFence)) {
                return 3;
            }
            int maximumCodeFenceLength = defaultCodeFence.length();
            Matcher matcher = CODE_FENCE_PATTERN.matcher(this.source);
            while (matcher.find()) {
                String codeFenceMatch = matcher.group();
                maximumCodeFenceLength = Math.max(maximumCodeFenceLength, codeFenceMatch.length());
            }
            return maximumCodeFenceLength + 1;
        }

        public String toString() {
            int codeFenceLength = this.calculateFenceLength();
            String codeFence = StringUtils.repeat((String)"`", (int)codeFenceLength);
            String codeBlock = codeFence.concat(this.highlightLanguage).concat("\n").concat(this.source.toString()).concat(codeFence);
            return StringUtils.wrap((String)codeBlock, (String)"\n");
        }
    }
}

