/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.benchmark;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import net.sourceforge.pmd.benchmark.TimeTracker;
import net.sourceforge.pmd.benchmark.TimedOperationCategory;
import net.sourceforge.pmd.benchmark.TimingReport;
import net.sourceforge.pmd.benchmark.TimingReportRenderer;
import org.apache.commons.lang3.StringUtils;

public class TextTimingReportRenderer
implements TimingReportRenderer {
    private static final String TIME_FORMAT = "{0,number,0.0000}";
    private static final String CUSTOM_COUNTER_FORMAT = "{0,number,###,###,###}";
    private static final int LABEL_COLUMN_WIDTH = 50;
    private static final int TIME_COLUMN_WIDTH = 12;
    private static final int SELF_TIME_COLUMN_WIDTH = 17;
    private static final int CALL_COLUMN_WIDTH = 9;
    private static final int COUNTER_COLUMN_WIDTH = 12;
    private static final int COLUMNS = 100;

    @Override
    public void render(TimingReport report, Writer writer0) throws IOException {
        PrintWriter writer = new PrintWriter(writer0);
        for (TimedOperationCategory category : TimedOperationCategory.values()) {
            Map<String, TimeTracker.TimedResult> labeledMeasurements = report.getLabeledMeasurements(category);
            if (labeledMeasurements.isEmpty()) continue;
            this.renderCategoryMeasurements(category, labeledMeasurements, writer);
        }
        this.renderHeader("Summary", writer);
        for (TimedOperationCategory category : TimedOperationCategory.values()) {
            TimeTracker.TimedResult timedResult = report.getUnlabeledMeasurements(category);
            if (timedResult == null) continue;
            this.renderMeasurement(category.displayName(), timedResult, writer);
        }
        writer.println();
        this.renderHeader("Total", writer);
        writer.write(StringUtils.rightPad((String)"Wall Clock Time", (int)50));
        String wallClockTime = MessageFormat.format(TIME_FORMAT, (double)report.getWallClockMillis() / 1000.0);
        writer.write(StringUtils.leftPad((String)wallClockTime, (int)12));
        writer.println();
        writer.flush();
    }

    private void renderMeasurement(String label, TimeTracker.TimedResult timedResult, PrintWriter writer) throws IOException {
        writer.write(StringUtils.rightPad((String)label, (int)50));
        String time = MessageFormat.format(TIME_FORMAT, (double)timedResult.totalTimeNanos.get() / 1.0E9);
        writer.write(StringUtils.leftPad((String)time, (int)12));
        String selfTime = MessageFormat.format(TIME_FORMAT, (double)timedResult.selfTimeNanos.get() / 1.0E9);
        writer.write(StringUtils.leftPad((String)selfTime, (int)17));
        if (timedResult.callCount.get() > 0) {
            String callCount = MessageFormat.format(CUSTOM_COUNTER_FORMAT, timedResult.callCount.get());
            writer.write(StringUtils.leftPad((String)callCount, (int)9));
            if (timedResult.extraDataCounter.get() > 0L) {
                String counter = MessageFormat.format(CUSTOM_COUNTER_FORMAT, timedResult.extraDataCounter.get());
                writer.write(StringUtils.leftPad((String)counter, (int)12));
            }
        }
        writer.println();
    }

    private void renderCategoryMeasurements(TimedOperationCategory category, Map<String, TimeTracker.TimedResult> labeledMeasurements, PrintWriter writer) throws IOException {
        this.renderHeader(category.displayName(), writer);
        TimeTracker.TimedResult grandTotal = new TimeTracker.TimedResult();
        TreeSet<Map.Entry> sortedKeySet = new TreeSet<Map.Entry>(Comparator.comparingLong(o -> ((TimeTracker.TimedResult)o.getValue()).selfTimeNanos.get()));
        sortedKeySet.addAll(labeledMeasurements.entrySet());
        for (Map.Entry entry : sortedKeySet) {
            this.renderMeasurement((String)entry.getKey(), (TimeTracker.TimedResult)entry.getValue(), writer);
            grandTotal.mergeTimes((TimeTracker.TimedResult)entry.getValue());
        }
        writer.println();
        this.renderMeasurement("Total " + category.displayName(), grandTotal, writer);
        writer.println();
    }

    private void renderHeader(String displayName, PrintWriter writer) throws IOException {
        StringBuilder sb = new StringBuilder(100).append(displayName);
        if (displayName.length() % 2 == 1) {
            sb.append(' ');
        }
        sb.insert(0, "<<< ").append(" >>>");
        while (sb.length() < 100) {
            sb.insert(0, '-').append('-');
        }
        writer.write(sb.toString());
        writer.println();
        writer.write(StringUtils.rightPad((String)"Label", (int)50));
        writer.write(StringUtils.leftPad((String)"Time (secs)", (int)12));
        writer.write(StringUtils.leftPad((String)"Self Time (secs)", (int)17));
        writer.write(StringUtils.leftPad((String)"# Calls", (int)9));
        writer.write(StringUtils.leftPad((String)"Counter", (int)12));
        writer.println();
        writer.println();
    }
}

