/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.registry;

import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.parser.Gcc4Cc1Parser;
import edu.hm.hafner.analysis.parser.Gcc4CompilerParser;
import edu.hm.hafner.analysis.parser.Gcc4LinkerParser;
import edu.hm.hafner.analysis.registry.CompositeParserDescriptor;
import java.util.Collection;

class Gcc4Descriptor
extends CompositeParserDescriptor {
    private static final String ID = "gcc";
    private static final String NAME = "GNU C Compiler (GCC)";

    Gcc4Descriptor() {
        super(ID, NAME);
    }

    @Override
    protected Collection<? extends IssueParser> createParsers() {
        return this.asList(new Gcc4CompilerParser(), new Gcc4LinkerParser(), new Gcc4Cc1Parser());
    }

    @Override
    public String getHelp() {
        return "<p>Parses warnings and errors generated by GCC version 4 and newer (including GCC 5\u201315+). Use this parser for modern GCC compilers that output messages in the standard format like:</p><p><code>file.c:10:5: warning: unused variable 'x' [-Wunused-variable]</code></p><p>For very old GCC versions (pre-GCC 4), use the 'gcc3' parser instead.</p>";
    }
}

